/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import com.anji.persistence.Persistence;
import com.anji.util.Configurable;
import com.anji.util.DummyConfiguration;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jgap.Chromosome;

public class NeatActivator
implements Configurable {
    private static Logger logger = Logger.getLogger(NeatActivator.class);
    private Persistence db;
    private List idxs = new ArrayList();
    private double[][] stimuli;
    private double[][] targets;
    private ActivatorTranscriber activatorFactory;
    private Randomizer randomizer;

    @Override
    public void init(Properties props) {
        try {
            this.randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
            this.db = (Persistence)props.singletonObjectProperty("persistence");
            this.activatorFactory = (ActivatorTranscriber)props.singletonObjectProperty(ActivatorTranscriber.class);
            this.stimuli = Properties.loadArrayFromFile(props.getResourceProperty("stimuli.file"));
            this.targets = Properties.loadArrayFromFile(props.getResourceProperty("targets.file"));
            if (this.stimuli.length == 0 || this.targets.length == 0) {
                throw new IllegalArgumentException("require at least 1 training set for stimuli [" + this.stimuli.length + "] and targets [" + this.targets.length + "]");
            }
            if (this.stimuli.length != this.targets.length) {
                throw new IllegalArgumentException("# training sets does not match for stimuli [" + this.stimuli.length + "] and targets [" + this.targets.length + "]");
            }
            int i = 0;
            while (i < this.stimuli.length) {
                this.idxs.add(new Integer(i));
                ++i;
            }
            Collections.sort(this.idxs);
            this.reset();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid properties: " + e.getClass().toString() + ": " + e.getMessage());
        }
    }

    public void reset() {
        Collections.shuffle(this.idxs, this.randomizer.getRand());
    }

    public SortedMap activate(String chromId) throws Exception {
        DummyConfiguration config = new DummyConfiguration();
        Chromosome chrom = this.db.loadChromosome(chromId, config);
        Activator activator = this.activatorFactory.newActivator(chrom);
        this.db.store(activator);
        return this.activate(activator);
    }

    public SortedMap activate(Activator activator) throws Exception {
        TreeMap<Integer, double[]> result2 = new TreeMap<Integer, double[]>();
        double[][] response = activator.next(this.stimuli);
        for (Integer idx : this.idxs) {
            result2.put(idx, response[idx]);
        }
        return result2;
    }

    public String displayActivation(String chromId) throws Exception {
        StringBuffer result2 = new StringBuffer();
        SortedMap responses = this.activate(chromId);
        for (Integer idx : responses.keySet()) {
            int i = idx;
            double[] response = (double[])responses.get(idx);
            result2.append(i).append(": IN (").append(this.stimuli[i][0]);
            int j = 1;
            while (j < this.stimuli[i].length) {
                result2.append(", ").append(this.stimuli[i][j]);
                ++j;
            }
            result2.append(")   OUT (").append(response[0]);
            j = 1;
            while (j < response.length) {
                result2.append(", ").append(response[j]);
                ++j;
            }
            result2.append(")   TARGET (").append(this.targets[i][0]);
            j = 1;
            while (j < this.targets[i].length) {
                result2.append(", ").append(this.targets[i][j]);
                ++j;
            }
            result2.append(")\n");
        }
        return result2.toString();
    }

    private static void printUsage() {
        System.err.println("activator <properties-file> <chromosome-id>");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 2) {
            NeatActivator.printUsage();
        } else {
            NeatActivator na = new NeatActivator();
            Properties props = new Properties(args[0]);
            na.init(props);
            logger.info("\n" + na.displayActivation(args[1]));
        }
    }
}

