/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatConfiguration;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jgap.Allele;
import org.jgap.ChromosomeMaterial;

public class NeatChromosomeUtility {
    private static Logger logger = Logger.getLogger(NeatChromosomeUtility.class);

    public static ChromosomeMaterial newSampleChromosomeMaterial(short newNumInputs, short newNumHidden, short newNumOutputs, NeatConfiguration config, boolean fullyConnected) {
        return new ChromosomeMaterial(NeatChromosomeUtility.initAlleles(newNumInputs, newNumHidden, newNumOutputs, config, fullyConnected));
    }

    public static Collection extractConnectionAllelesForDestNeurons(Collection connAlleles, Collection destNeuronInnovationIds) {
        ArrayList<ConnectionAllele> result2 = new ArrayList<ConnectionAllele>();
        for (ConnectionAllele cAllele : connAlleles) {
            if (!destNeuronInnovationIds.contains(cAllele.getDestNeuronId())) continue;
            result2.add(cAllele);
        }
        return result2;
    }

    public static Collection extractConnectionAllelesForSrcNeurons(Collection connAlleles, Collection srcNeuronInnovationIds) {
        ArrayList<ConnectionAllele> result2 = new ArrayList<ConnectionAllele>();
        for (ConnectionAllele connAllele : connAlleles) {
            if (!srcNeuronInnovationIds.contains(connAllele.getSrcNeuronId())) continue;
            result2.add(connAllele);
        }
        return result2;
    }

    private static List initAlleles(short numInputs, short numHidden, short numOutputs, NeatConfiguration config, boolean fullyConnected) {
        ConnectionAllele c2;
        NeuronAllele srcNeuronAllele;
        int i;
        ArrayList<NeuronAllele> inNeurons = new ArrayList<NeuronAllele>(numInputs);
        ArrayList<NeuronAllele> outNeurons = new ArrayList<NeuronAllele>(numOutputs);
        ArrayList<NeuronAllele> hidNeurons = new ArrayList<NeuronAllele>(numHidden);
        ArrayList<ConnectionAllele> conns = new ArrayList<ConnectionAllele>();
        int i2 = 0;
        while (i2 < numInputs) {
            inNeurons.add(config.newNeuronAllele(NeuronType.INPUT));
            ++i2;
        }
        int j = 0;
        while (j < numOutputs) {
            NeuronAllele outNeuron = config.newNeuronAllele(NeuronType.OUTPUT);
            outNeurons.add(outNeuron);
            if (fullyConnected && numHidden == 0) {
                i = 0;
                while (i < numInputs) {
                    srcNeuronAllele = (NeuronAllele)inNeurons.get(i);
                    c2 = config.newConnectionAllele(srcNeuronAllele.getInnovationId(), outNeuron.getInnovationId());
                    if (config != null) {
                        c2.setToRandomValue(config.getRandomGenerator());
                    }
                    conns.add(c2);
                    ++i;
                }
            }
            ++j;
        }
        if (fullyConnected) {
            int k = 0;
            while (k < numHidden) {
                NeuronAllele hidNeuron = config.newNeuronAllele(NeuronType.HIDDEN);
                hidNeurons.add(hidNeuron);
                i = 0;
                while (i < numInputs) {
                    srcNeuronAllele = (NeuronAllele)inNeurons.get(i);
                    c2 = config.newConnectionAllele(srcNeuronAllele.getInnovationId(), hidNeuron.getInnovationId());
                    if (config != null) {
                        c2.setToRandomValue(config.getRandomGenerator());
                    }
                    conns.add(c2);
                    ++i;
                }
                int j2 = 0;
                while (j2 < numOutputs) {
                    NeuronAllele destNeuronAllele = (NeuronAllele)outNeurons.get(j2);
                    c2 = config.newConnectionAllele(hidNeuron.getInnovationId(), destNeuronAllele.getInnovationId());
                    if (config != null) {
                        c2.setToRandomValue(config.getRandomGenerator());
                    }
                    conns.add(c2);
                    ++j2;
                }
                ++k;
            }
        } else if (numHidden > 0) {
            logger.warn("ignoring intial topology hidden neurons, not fully connected");
        }
        ArrayList<Allele> result2 = new ArrayList<Allele>();
        result2.addAll(inNeurons);
        result2.addAll(outNeurons);
        result2.addAll(hidNeurons);
        result2.addAll(conns);
        Collections.sort(result2);
        return result2;
    }

    public static SortedMap getNeuronMap(Collection alleles) {
        return NeatChromosomeUtility.getNeuronMap(alleles, null);
    }

    public static List getNeuronList(Collection alleles) {
        return NeatChromosomeUtility.getNeuronList(alleles, null);
    }

    public static SortedMap getNeuronMap(Collection alleles, NeuronType type) {
        TreeMap<Long, Allele> result2 = new TreeMap<Long, Allele>();
        for (Allele allele : alleles) {
            if (!(allele instanceof NeuronAllele)) continue;
            NeuronAllele neuronAllele = (NeuronAllele)allele;
            Long id = neuronAllele.getInnovationId();
            if (result2.containsKey(id)) {
                throw new IllegalArgumentException("chromosome contains duplicate neuron gene: " + allele.toString());
            }
            if (type != null && !neuronAllele.isType(type)) continue;
            result2.put(id, allele);
        }
        return result2;
    }

    public static List getNeuronList(Collection alleles, NeuronType type) {
        ArrayList<Allele> result2 = new ArrayList<Allele>();
        for (Allele allele : alleles) {
            if (!(allele instanceof NeuronAllele)) continue;
            NeuronAllele nAllele = (NeuronAllele)allele;
            if (result2.contains(nAllele)) {
                throw new IllegalArgumentException("chromosome contains duplicate neuron gene: " + allele.toString());
            }
            if (type != null && !nAllele.isType(type)) continue;
            result2.add(allele);
        }
        return result2;
    }

    public static SortedMap getConnectionMap(Set alleles) {
        TreeMap<Long, Allele> result2 = new TreeMap<Long, Allele>();
        for (Allele allele : alleles) {
            if (!(allele instanceof ConnectionAllele)) continue;
            ConnectionAllele connAllele = (ConnectionAllele)allele;
            Long id = connAllele.getInnovationId();
            if (result2.containsKey(id)) {
                throw new IllegalArgumentException("chromosome contains duplicate connection gene: " + allele.toString());
            }
            result2.put(id, allele);
        }
        return result2;
    }

    public static List getConnectionList(Collection alleles) {
        ArrayList<Allele> result2 = new ArrayList<Allele>();
        for (Allele allele : alleles) {
            if (!(allele instanceof ConnectionAllele)) continue;
            if (result2.contains(allele)) {
                throw new IllegalArgumentException("chromosome contains duplicate connection gene: " + allele.toString());
            }
            result2.add(allele);
        }
        return result2;
    }

    public static boolean neuronsAreConnected(Long srcNeuronId, Long destNeuronId, Collection connGenes) {
        return NeatChromosomeUtility.neuronsAreConnected(srcNeuronId, destNeuronId, connGenes, new HashSet());
    }

    private static boolean neuronsAreConnected(Long srcNeuronId, Long destNeuronId, Collection allConnAlleles, Set alreadyTraversedConnIds) {
        if (alreadyTraversedConnIds.contains(srcNeuronId)) {
            return false;
        }
        alreadyTraversedConnIds.add(srcNeuronId);
        if (srcNeuronId.equals(destNeuronId)) {
            return true;
        }
        for (ConnectionAllele connAllele : allConnAlleles) {
            if (connAllele.getSrcNeuronId().equals(connAllele.getDestNeuronId()) || !connAllele.getSrcNeuronId().equals(srcNeuronId) || !NeatChromosomeUtility.neuronsAreConnected(connAllele.getDestNeuronId(), destNeuronId, allConnAlleles, alreadyTraversedConnIds)) continue;
            return true;
        }
        return false;
    }
}

