/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.SimpleSelector;
import com.anji.neat.AddConnectionMutationOperator;
import com.anji.neat.AddNeuronMutationOperator;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.ConnectionGene;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatCrossoverReproductionOperator;
import com.anji.neat.NeatIdMap;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronGene;
import com.anji.neat.NeuronType;
import com.anji.neat.PruneMutationOperator;
import com.anji.neat.RemoveConnectionMutationOperator;
import com.anji.neat.SingleTopologicalMutationOperator;
import com.anji.neat.WeightMutationOperator;
import com.anji.nn.ActivationFunctionType;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.IdFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.event.EventManager;
import org.jgap.impl.CloneReproductionOperator;
import org.jgap.impl.WeightedRouletteSelector;

public class NeatConfiguration
extends Configuration {
    private static final Logger logger = Logger.getLogger(NeatConfiguration.class);
    public static final String ID_FACTORY_KEY = "id.file";
    private static final short DEFAULT_STIMULUS_SIZE = 3;
    private static final short DEFAULT_INITIAL_HIDDEN_SIZE = 0;
    private static final short DEFAULT_RESPONSE_SIZE = 3;
    public static final float DEFAULT_SURVIVAL_RATE = 0.2f;
    public static final int DEFAULT_POPUL_SIZE = 100;
    public static final String STIMULUS_SIZE_KEY = "stimulus.size";
    public static final String RESPONSE_SIZE_KEY = "response.size";
    public static final String SURVIVAL_RATE_KEY = "survival.rate";
    public static final String TOPOLOGY_MUTATION_CLASSIC_KEY = "topology.mutation.classic";
    public static final String WEIGHT_MAX_KEY = "weight.max";
    public static final String WEIGHT_MIN_KEY = "weight.min";
    public static final String POPUL_SIZE_KEY = "popul.size";
    public static final String CHROM_COMPAT_EXCESS_COEFF_KEY = "chrom.compat.excess.coeff";
    public static final String CHROM_COMPAT_DISJOINT_COEFF_KEY = "chrom.compat.disjoint.coeff";
    public static final String CHROM_COMPAT_COMMON_COEFF_KEY = "chrom.compat.common.coeff";
    public static final String SPECIATION_THRESHOLD_KEY = "speciation.threshold";
    public static final String ELITISM_KEY = "selector.elitism";
    public static final String ELITISM_MIN_SPECIE_SIZE_KEY = "selector.elitism.min.specie.size";
    public static final String WEIGHTED_SELECTOR_KEY = "selector.roulette";
    public static final String INITIAL_TOPOLOGY_FULLY_CONNECTED_KEY = "initial.topology.fully.connected";
    public static final String INITIAL_TOPOLOGY_NUM_HIDDEN_NEURONS_KEY = "initial.topology.num.hidden.neurons";
    public static final String INITIAL_TOPOLOGY_ACTIVATION_KEY = "initial.topology.activation";
    public static final String INITIAL_TOPOLOGY_ACTIVATION_INPUT_KEY = "initial.topology.activation.input";
    public static final String INITIAL_TOPOLOGY_ACTIVATION_OUTPUT_KEY = "initial.topology.activation.output";
    private Properties props;
    private CloneReproductionOperator cloneOper = null;
    private NeatCrossoverReproductionOperator crossoverOper = null;
    private double maxConnectionWeight = Double.MAX_VALUE;
    private double minConnectionWeight = -1.7976931348623157E308;
    private ActivationFunctionType inputActivationType;
    private ActivationFunctionType outputActivationType;
    private ActivationFunctionType hiddenActivationType;
    private NeatIdMap neatIdMap;

    private void initMutation() throws InvalidConfigurationException {
        PruneMutationOperator pruneOperator;
        WeightMutationOperator weightOperator;
        boolean isTopologyMutationClassic;
        RemoveConnectionMutationOperator removeOperator = (RemoveConnectionMutationOperator)this.props.singletonObjectProperty(RemoveConnectionMutationOperator.class);
        if (removeOperator.getMutationRate() > 0.0f && removeOperator.getMaxWeightRemoved() > 0.0f) {
            this.addMutationOperator(removeOperator);
        }
        if (isTopologyMutationClassic = this.props.getBooleanProperty(TOPOLOGY_MUTATION_CLASSIC_KEY, false)) {
            SingleTopologicalMutationOperator singleOperator = (SingleTopologicalMutationOperator)this.props.singletonObjectProperty(SingleTopologicalMutationOperator.class);
            if (singleOperator.getMutationRate() > 0.0f) {
                this.addMutationOperator(singleOperator);
            }
        } else {
            AddNeuronMutationOperator addNeuronOperator;
            AddConnectionMutationOperator addConnOperator = (AddConnectionMutationOperator)this.props.singletonObjectProperty(AddConnectionMutationOperator.class);
            if (addConnOperator.getMutationRate() > 0.0f) {
                this.addMutationOperator(addConnOperator);
            }
            if ((addNeuronOperator = (AddNeuronMutationOperator)this.props.singletonObjectProperty(AddNeuronMutationOperator.class)).getMutationRate() > 0.0f) {
                this.addMutationOperator(addNeuronOperator);
            }
        }
        if ((weightOperator = (WeightMutationOperator)this.props.singletonObjectProperty(WeightMutationOperator.class)).getMutationRate() > 0.0f) {
            this.addMutationOperator(weightOperator);
        }
        if ((pruneOperator = (PruneMutationOperator)this.props.singletonObjectProperty(PruneMutationOperator.class)).getMutationRate() > 0.0f) {
            this.addMutationOperator(pruneOperator);
        }
    }

    private void init(Properties newProps) throws InvalidConfigurationException {
        this.props = newProps;
        Randomizer r = (Randomizer)this.props.singletonObjectProperty(Randomizer.class);
        this.setRandomGenerator(r.getRand());
        this.setEventManager(new EventManager());
        String s = this.props.getProperty(ID_FACTORY_KEY, null);
        try {
            if (s != null) {
                this.setIdFactory(new IdFactory(s));
            }
        }
        catch (IOException e) {
            String msg = "could not load IDs";
            logger.error(msg, e);
            throw new InvalidConfigurationException(msg);
        }
        float survivalRate = this.props.getFloatProperty(SURVIVAL_RATE_KEY, 0.2f);
        float crossoverSlice = 1.0f - 2.0f * survivalRate;
        if (crossoverSlice < 0.0f) {
            throw new InvalidConfigurationException("survival rate too large: " + survivalRate);
        }
        NaturalSelector selector = null;
        selector = this.props.getBooleanProperty(WEIGHTED_SELECTOR_KEY, false) ? new WeightedRouletteSelector() : new SimpleSelector();
        selector.setSurvivalRate(survivalRate);
        selector.setElitism(this.props.getBooleanProperty(ELITISM_KEY, true));
        selector.setElitismMinSpecieSize(this.props.getIntProperty(ELITISM_MIN_SPECIE_SIZE_KEY, 6));
        this.setNaturalSelector(selector);
        this.cloneOper = new CloneReproductionOperator();
        this.crossoverOper = new NeatCrossoverReproductionOperator();
        this.getCloneOperator().setSlice(survivalRate);
        this.getCrossoverOperator().setSlice(crossoverSlice);
        this.addReproductionOperator(this.getCloneOperator());
        this.addReproductionOperator(this.getCrossoverOperator());
        this.initMutation();
        this.setPopulationSize(this.props.getIntProperty(POPUL_SIZE_KEY, 100));
        this.hiddenActivationType = ActivationFunctionType.valueOf(this.props.getProperty(INITIAL_TOPOLOGY_ACTIVATION_KEY, ActivationFunctionType.SIGMOID.toString()));
        this.inputActivationType = ActivationFunctionType.valueOf(this.props.getProperty(INITIAL_TOPOLOGY_ACTIVATION_INPUT_KEY, null));
        if (this.inputActivationType == null) {
            this.inputActivationType = this.hiddenActivationType;
        }
        this.outputActivationType = ActivationFunctionType.valueOf(this.props.getProperty(INITIAL_TOPOLOGY_ACTIVATION_OUTPUT_KEY, null));
        if (this.outputActivationType == null) {
            this.outputActivationType = this.hiddenActivationType;
        }
        this.load();
        ChromosomeMaterial sample = NeatChromosomeUtility.newSampleChromosomeMaterial(this.props.getShortProperty(STIMULUS_SIZE_KEY, (short)3), this.props.getShortProperty(INITIAL_TOPOLOGY_NUM_HIDDEN_NEURONS_KEY, (short)0), this.props.getShortProperty(RESPONSE_SIZE_KEY, (short)3), this, this.props.getBooleanProperty(INITIAL_TOPOLOGY_FULLY_CONNECTED_KEY, true));
        this.setSampleChromosomeMaterial(sample);
        this.store();
        this.minConnectionWeight = this.props.getDoubleProperty(WEIGHT_MIN_KEY, -1.7976931348623157E308);
        this.maxConnectionWeight = this.props.getDoubleProperty(WEIGHT_MAX_KEY, Double.MAX_VALUE);
        this.initSpeciationParms();
    }

    public NeatConfiguration(Properties newProps) throws InvalidConfigurationException {
        this.init(newProps);
    }

    private void initSpeciationParms() {
        try {
            this.getSpeciationParms().setSpecieCompatExcessCoeff(this.props.getDoubleProperty(CHROM_COMPAT_EXCESS_COEFF_KEY));
        }
        catch (RuntimeException e) {
            logger.info("no speciation compatibility threshold specified", e);
        }
        try {
            this.getSpeciationParms().setSpecieCompatDisjointCoeff(this.props.getDoubleProperty(CHROM_COMPAT_DISJOINT_COEFF_KEY));
        }
        catch (RuntimeException e) {
            logger.info("no speciation compatibility threshold specified", e);
        }
        try {
            this.getSpeciationParms().setSpecieCompatCommonCoeff(this.props.getDoubleProperty(CHROM_COMPAT_COMMON_COEFF_KEY));
        }
        catch (RuntimeException e) {
            logger.info("no speciation compatibility threshold specified", e);
        }
        try {
            this.getSpeciationParms().setSpeciationThreshold(this.props.getDoubleProperty(SPECIATION_THRESHOLD_KEY));
        }
        catch (RuntimeException e) {
            logger.info("no speciation compatibility threshold specified", e);
        }
    }

    public NeuronAllele newNeuronAllele(NeuronType type) {
        ActivationFunctionType act = NeuronType.INPUT.equals(type) ? this.inputActivationType : (NeuronType.OUTPUT.equals(type) ? this.outputActivationType : this.hiddenActivationType);
        NeuronGene gene = new NeuronGene(type, this.nextInnovationId(), act);
        return new NeuronAllele(gene);
    }

    public NeuronAllele newNeuronAllele(Long connectionId) {
        Long id = this.neatIdMap.findNeuronId(connectionId);
        if (id == null) {
            id = this.nextInnovationId();
            this.neatIdMap.putNeuronId(connectionId, id);
        }
        NeuronGene gene = new NeuronGene(NeuronType.HIDDEN, id, this.hiddenActivationType);
        return new NeuronAllele(gene);
    }

    public ConnectionAllele newConnectionAllele(Long srcNeuronId, Long destNeuronId) {
        Long id = this.neatIdMap.findConnectionId(srcNeuronId, destNeuronId);
        if (id == null) {
            id = this.nextInnovationId();
            this.neatIdMap.putConnectionId(srcNeuronId, destNeuronId, id);
        }
        ConnectionGene gene = new ConnectionGene(id, srcNeuronId, destNeuronId);
        return new ConnectionAllele(gene);
    }

    public CloneReproductionOperator getCloneOperator() {
        return this.cloneOper;
    }

    public NeatCrossoverReproductionOperator getCrossoverOperator() {
        return this.crossoverOper;
    }

    public double getMaxConnectionWeight() {
        return this.maxConnectionWeight;
    }

    public double getMinConnectionWeight() {
        return this.minConnectionWeight;
    }

    public void load() throws InvalidConfigurationException {
        if (this.neatIdMap == null) {
            this.neatIdMap = new NeatIdMap(this.props);
            try {
                this.neatIdMap.load();
            }
            catch (IOException e) {
                String msg = "error loading ID map";
                logger.error(msg, e);
                throw new InvalidConfigurationException(msg);
            }
        }
    }

    public void store() throws InvalidConfigurationException {
        try {
            this.getIdFactory().store();
            if (this.neatIdMap.store()) {
                this.neatIdMap = null;
            }
        }
        catch (IOException e) {
            String msg = "error storing ID map";
            logger.error(msg, e);
            throw new InvalidConfigurationException(msg);
        }
    }

    public void logIdMaps(Logger aLogger, Priority pri) {
        this.neatIdMap.log(aLogger, pri);
    }
}

