/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.util.Properties;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NeatIdMap {
    private static final Logger logger = Logger.getLogger(NeatIdMap.class);
    public static final String NEAT_ID_MAP_FILE_KEY = "neat.id.file";
    public static final String NEAT_ID_MAP_XML_TAG = "neat_id_map";
    public static final String NEURON_ID_MAP_XML_TAG = "neuron_id_map";
    public static final String CONNECTION_ID_MAP_XML_TAG = "connection_id_map";
    public static final String CONNECTION_TO_NEURON_XML_TAG = "neuron";
    public static final String ID_XML_TAG = "id";
    public static final String CONNECTION_ID_XML_TAG = "connection_id";
    public static final String CONNECTION_TO_CONNECTION_XML_TAG = "connection";
    public static final String SRC_NEURON_ID_XML_TAG = "src_neuron_id";
    public static final String DEST_NEURON_ID_XML_TAG = "dest_neuron_id";
    private Map connectionToNeuronId = new HashMap();
    private Map connectionToConnectionId = new HashMap();
    private String neatIdMapFileName = null;

    public NeatIdMap(Properties newProps) {
        this.init(newProps);
    }

    private void init(Properties props) {
        this.neatIdMapFileName = props.getProperty(NEAT_ID_MAP_FILE_KEY, null);
    }

    public Long findNeuronId(Long connectionId) {
        return (Long)this.connectionToNeuronId.get(connectionId);
    }

    public Long findConnectionId(Long srcNeuronId, Long destNeuronId) {
        return (Long)this.connectionToConnectionId.get(this.buildList(srcNeuronId, destNeuronId));
    }

    protected void putNeuronId(Long connectionId, Long newNeuronId) {
        this.connectionToNeuronId.put(connectionId, newNeuronId);
    }

    protected void putConnectionId(Long srcNeuronId, Long destNeuronId, Long newConnectionId) {
        this.connectionToConnectionId.put(this.buildList(srcNeuronId, destNeuronId), newConnectionId);
    }

    protected List buildList(Long srcNeuronId, Long destNeuronId) {
        ArrayList<Long> result2 = new ArrayList<Long>();
        result2.add(srcNeuronId);
        result2.add(destNeuronId);
        return result2;
    }

    public void load() throws IOException {
        if (this.neatIdMapFileName != null) {
            try (FileInputStream in = null;){
                try {
                    in = new FileInputStream(this.neatIdMapFileName);
                    this.neatIdMapFromXml(in);
                }
                catch (Exception e) {
                    logger.info("couldn't load NEAT ids from file, starting with new mapping");
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
    }

    public boolean store() throws IOException {
        if (this.neatIdMapFileName != null) {
            try (FileWriter out = null;){
                out = new FileWriter(this.neatIdMapFileName);
                out.write(this.toXml());
                out.flush();
                return true;
            }
        }
        return false;
    }

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(NEAT_ID_MAP_XML_TAG).append(">\n");
        result2.append("<").append(NEURON_ID_MAP_XML_TAG).append(">\n");
        for (Long connId : this.connectionToNeuronId.keySet()) {
            Long neuronId = (Long)this.connectionToNeuronId.get(connId);
            result2.append("<").append(CONNECTION_TO_NEURON_XML_TAG).append(" ");
            result2.append(ID_XML_TAG).append("=\"").append(neuronId).append("\" ");
            result2.append(CONNECTION_ID_XML_TAG).append("=\"").append(connId).append("\" />");
        }
        result2.append("</").append(NEURON_ID_MAP_XML_TAG).append(">\n");
        result2.append("<").append(CONNECTION_ID_MAP_XML_TAG).append(">\n");
        for (List key : this.connectionToConnectionId.keySet()) {
            Long srcNeuronId = (Long)key.get(0);
            Long destNeuronId = (Long)key.get(1);
            Long connId = (Long)this.connectionToConnectionId.get(key);
            result2.append("<").append(CONNECTION_TO_CONNECTION_XML_TAG).append(" ");
            result2.append(ID_XML_TAG).append("=\"").append(connId).append("\" ");
            result2.append(SRC_NEURON_ID_XML_TAG).append("=\"").append(srcNeuronId).append("\" ");
            result2.append(DEST_NEURON_ID_XML_TAG).append("=\"").append(destNeuronId).append("\" />");
        }
        result2.append("</").append(CONNECTION_ID_MAP_XML_TAG).append(">\n");
        result2.append("</").append(NEAT_ID_MAP_XML_TAG).append(">\n");
        return result2.toString();
    }

    private void neatIdMapFromXml(InputStream in) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        Node node = doc.getFirstChild();
        if (!NEAT_ID_MAP_XML_TAG.equals(node.getNodeName())) {
            throw new IllegalArgumentException("tag != neat_id_map");
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (NEURON_ID_MAP_XML_TAG.equals(child.getNodeName())) {
                this.neuronIdMapFromXml(child);
            } else if (CONNECTION_ID_MAP_XML_TAG.equals(child.getNodeName())) {
                this.connectionIdMapFromXml(child);
            }
            ++i;
        }
    }

    private void neuronIdMapFromXml(Node xml) {
        NodeList children = xml.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (CONNECTION_TO_NEURON_XML_TAG.equals(child.getNodeName())) {
                NamedNodeMap attrs = child.getAttributes();
                if (attrs == null) {
                    throw new IllegalArgumentException("missing attributes");
                }
                Node neuronIdAttr = attrs.getNamedItem(ID_XML_TAG);
                if (neuronIdAttr == null) {
                    throw new IllegalArgumentException("missing neuron id");
                }
                Node connIdAttr = attrs.getNamedItem(CONNECTION_ID_XML_TAG);
                if (connIdAttr == null) {
                    throw new IllegalArgumentException("missing connection id");
                }
                this.putNeuronId(Long.valueOf(connIdAttr.getNodeValue()), Long.valueOf(neuronIdAttr.getNodeValue()));
            }
            ++i;
        }
    }

    private void connectionIdMapFromXml(Node xml) {
        NodeList children = xml.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (CONNECTION_TO_CONNECTION_XML_TAG.equals(child.getNodeName())) {
                NamedNodeMap attrs = child.getAttributes();
                if (attrs == null) {
                    throw new IllegalArgumentException("missing attributes");
                }
                Node connIdAttr = attrs.getNamedItem(ID_XML_TAG);
                if (connIdAttr == null) {
                    throw new IllegalArgumentException("missing connection id");
                }
                Node srcNeuronIdAttr = attrs.getNamedItem(SRC_NEURON_ID_XML_TAG);
                if (srcNeuronIdAttr == null) {
                    throw new IllegalArgumentException("missing src neuron id");
                }
                Node destNeuronIdAttr = attrs.getNamedItem(DEST_NEURON_ID_XML_TAG);
                if (destNeuronIdAttr == null) {
                    throw new IllegalArgumentException("missing dest neuron id");
                }
                this.putConnectionId(Long.valueOf(srcNeuronIdAttr.getNodeValue()), Long.valueOf(destNeuronIdAttr.getNodeValue()), Long.valueOf(connIdAttr.getNodeValue()));
            }
            ++i;
        }
    }

    public void log(Logger aLogger, Priority pri) {
        aLogger.log(pri, "connection->neuron id map size == " + this.connectionToNeuronId.size());
        aLogger.log(pri, "neurons->connection id map size == " + this.connectionToConnectionId.size());
    }
}

