/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.ErrorFunction;
import com.anji.integration.TargetFitnessFunction;
import com.anji.util.Properties;

public class NeatTargetFitnessFunction
extends TargetFitnessFunction {
    private static final boolean SUM_OF_SQUARES = false;
    private static final int MAX_FITNESS = 160000000;

    @Override
    public void init(Properties newProps) {
        try {
            super.init(newProps);
            ErrorFunction.getInstance().init(newProps);
            this.setMaxFitnessValue(160000000);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid properties: " + e.getClass().toString() + ": " + e.getMessage());
        }
    }

    @Override
    protected int calculateErrorFitness(double[][] responses, double minResponse, double maxResponse) {
        double maxSumDiff = ErrorFunction.getInstance().getMaxError(this.getTargets().length * this.getTargets()[0].length, maxResponse - minResponse, false);
        double maxRawFitnessValue = Math.pow(maxSumDiff, 2.0);
        double sumDiff = ErrorFunction.getInstance().calculateError(this.getTargets(), responses, false);
        if (sumDiff > maxSumDiff) {
            throw new IllegalStateException("sum diff > max sum diff");
        }
        double rawFitnessValue = Math.pow(maxSumDiff - sumDiff, 2.0);
        double skewedFitness = rawFitnessValue / maxRawFitnessValue * 1.6E8;
        int result2 = (int)skewedFitness;
        return result2;
    }
}

