/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeuronAllele;
import com.anji.neat.NeuronType;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class PruneMutationOperator
extends MutationOperator
implements Configurable {
    private static final String PRUNE_MUTATE_RATE_KEY = "prune.mutation.rate";
    public static final float DEFAULT_MUTATE_RATE = 1.0f;

    @Override
    public void init(Properties props) throws Exception {
        this.setMutationRate(props.getFloatProperty(PRUNE_MUTATE_RATE_KEY, 1.0f));
    }

    public PruneMutationOperator() {
        this(1.0f);
    }

    public PruneMutationOperator(float newMutationRate) {
        super(newMutationRate);
    }

    @Override
    protected void mutate(Configuration config, ChromosomeMaterial target, Set genesToAdd, Set genesToRemove) {
        ArrayList candidatesToRemove = new ArrayList();
        this.findUnvisitedAlleles(target, candidatesToRemove, true);
        this.findUnvisitedAlleles(target, candidatesToRemove, false);
        Collections.shuffle(candidatesToRemove, config.getRandomGenerator());
        int i = 0;
        while (i < this.numMutations(config.getRandomGenerator(), candidatesToRemove.size())) {
            genesToRemove.add(candidatesToRemove.get(i));
            ++i;
        }
    }

    private void findUnvisitedAlleles(ChromosomeMaterial material, List unvisitedAlleles, boolean isForward) {
        List unvisitedConnAlleles = NeatChromosomeUtility.getConnectionList(material.getAlleles());
        SortedMap hiddenNeuronAlleles = NeatChromosomeUtility.getNeuronMap(material.getAlleles(), NeuronType.HIDDEN);
        HashSet unvisitedNeuronInnovationIds = new HashSet(hiddenNeuronAlleles.keySet());
        SortedMap initialNeuronAlleles = NeatChromosomeUtility.getNeuronMap(material.getAlleles(), isForward ? NeuronType.INPUT : NeuronType.OUTPUT);
        HashSet currentNeuronInnovationIds = new HashSet(initialNeuronAlleles.keySet());
        HashSet<Long> nextNeuronInnovationIds = new HashSet<Long>();
        while (!unvisitedConnAlleles.isEmpty() && !currentNeuronInnovationIds.isEmpty()) {
            nextNeuronInnovationIds.clear();
            Collection connAlleles = isForward ? NeatChromosomeUtility.extractConnectionAllelesForSrcNeurons(unvisitedConnAlleles, currentNeuronInnovationIds) : NeatChromosomeUtility.extractConnectionAllelesForDestNeurons(unvisitedConnAlleles, currentNeuronInnovationIds);
            for (ConnectionAllele connAllele : connAlleles) {
                nextNeuronInnovationIds.add(isForward ? connAllele.getDestNeuronId() : connAllele.getSrcNeuronId());
            }
            unvisitedNeuronInnovationIds.removeAll(nextNeuronInnovationIds);
            currentNeuronInnovationIds.clear();
            currentNeuronInnovationIds.addAll(nextNeuronInnovationIds);
            unvisitedConnAlleles.removeAll(connAlleles);
        }
        unvisitedAlleles.addAll(unvisitedConnAlleles);
        for (Long id : unvisitedNeuronInnovationIds) {
            NeuronAllele neuronAllele = (NeuronAllele)hiddenNeuronAlleles.get(id);
            unvisitedAlleles.add(neuronAllele);
        }
    }
}

