/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.AnjiRequiredException;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.neat.WeightMagnitudeComparator;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class RemoveConnectionMutationOperator
extends MutationOperator
implements Configurable {
    private static final String STRATEGY_KEY = "remove.connection.strategy";
    public static final String REMOVE_CONN_MAX_WEIGHT_KEY = "remove.connection.max.weight";
    private static final String REMOVE_CONN_MUTATE_RATE_KEY = "remove.connection.mutation.rate";
    public static final float DEFAULT_MAX_WEIGHT_REMOVED = 0.1f;
    public static final float DEFAULT_MUTATE_RATE = 0.01f;
    private float maxWeightRemoved = 0.1f;
    private Strategy strategy = Strategy.SKEWED;

    @Override
    public void init(Properties props) throws Exception {
        this.setMutationRate(props.getFloatProperty(REMOVE_CONN_MUTATE_RATE_KEY, 0.01f));
        this.maxWeightRemoved = props.getFloatProperty(REMOVE_CONN_MAX_WEIGHT_KEY, 0.1f);
        this.strategy = Strategy.valueOf(props.getProperty(STRATEGY_KEY, Strategy.SKEWED.toString()));
    }

    public RemoveConnectionMutationOperator() {
        this(0.01f);
    }

    public RemoveConnectionMutationOperator(float aMutationRate) {
        super(aMutationRate);
    }

    public RemoveConnectionMutationOperator(float aMutationRate, float aMaxWeightRemoved) {
        super(aMutationRate);
        this.maxWeightRemoved = aMaxWeightRemoved;
    }

    public RemoveConnectionMutationOperator(float aMutationRate, float aMaxWeightRemoved, Strategy aStrategy) {
        super(aMutationRate);
        this.maxWeightRemoved = aMaxWeightRemoved;
        this.strategy = aStrategy;
    }

    @Override
    protected void mutate(Configuration jgapConfig, ChromosomeMaterial target, Set allelesToAdd, Set allelesToRemove) {
        if (!(jgapConfig instanceof NeatConfiguration)) {
            throw new AnjiRequiredException("com.anji.neat.NeatConfiguration");
        }
        NeatConfiguration config = (NeatConfiguration)jgapConfig;
        List allConns = NeatChromosomeUtility.getConnectionList(target.getAlleles());
        if (Strategy.SMALL.equals(this.strategy)) {
            this.mutateSmall(config, allConns, allelesToRemove);
        } else if (Strategy.ALL.equals(this.strategy)) {
            this.mutateAll(config, allConns, allelesToRemove);
        } else if (Strategy.SKEWED.equals(this.strategy)) {
            this.mutateSkewed(config, allConns, allelesToRemove);
        } else {
            throw new IllegalStateException("invalid remove connection operator strategy: " + this.strategy);
        }
    }

    private void mutateSkewed(NeatConfiguration config, List allConns, Set allelesToRemove) {
        for (ConnectionAllele connAllele : allConns) {
            float absWeight = (float)Math.abs(connAllele.getWeight());
            float smallWeightFactor = 0.0f;
            if (absWeight < this.maxWeightRemoved) {
                smallWeightFactor = (this.maxWeightRemoved - absWeight) / this.maxWeightRemoved;
            }
            smallWeightFactor *= smallWeightFactor;
            if (!RemoveConnectionMutationOperator.doesMutationOccur(config.getRandomGenerator(), smallWeightFactor * this.getMutationRate())) continue;
            allelesToRemove.add(connAllele);
        }
    }

    private void mutateAll(NeatConfiguration config, List allConns, Set allelesToRemove) {
        for (ConnectionAllele connAllele : allConns) {
            if (!(Math.abs(connAllele.getWeight()) <= (double)this.maxWeightRemoved) || !this.doesMutationOccur(config.getRandomGenerator())) continue;
            allelesToRemove.add(connAllele);
        }
    }

    private void mutateSmall(NeatConfiguration config, List allConns, Set allelesToRemove) {
        int maxConnsRemoved = this.numMutations(config.getRandomGenerator(), allConns.size());
        ArrayList candidateConns = new ArrayList(allConns);
        Iterator iter = candidateConns.iterator();
        while (iter.hasNext()) {
            ConnectionAllele conn = (ConnectionAllele)iter.next();
            if (!(Math.abs(conn.getWeight()) > (double)this.maxWeightRemoved)) continue;
            iter.remove();
        }
        Collections.sort(candidateConns, WeightMagnitudeComparator.getInstance());
        iter = candidateConns.iterator();
        int i = 0;
        while (iter.hasNext() && i++ < maxConnsRemoved) {
            ConnectionAllele connAllele = (ConnectionAllele)iter.next();
            allelesToRemove.add(connAllele);
        }
    }

    public float getMaxWeightRemoved() {
        return this.maxWeightRemoved;
    }

    public static class Strategy {
        private String name;
        public static final Strategy ALL = new Strategy("all");
        public static final Strategy SKEWED = new Strategy("skewed");
        public static final Strategy SMALL = new Strategy("small");
        private static final HashMap strategies = new HashMap();

        static {
            strategies.put(ALL.toString(), ALL);
            strategies.put(SKEWED.toString(), SKEWED);
            strategies.put(SMALL.toString(), SMALL);
        }

        private Strategy(String aName) {
            this.name = aName;
        }

        public String toString() {
            return this.name;
        }

        public static Strategy valueOf(String s) {
            return (Strategy)strategies.get(s);
        }
    }
}

