/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.AnjiRequiredException;
import com.anji.neat.AddConnectionMutationOperator;
import com.anji.neat.AddNeuronMutationOperator;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.nn.RecurrencyPolicy;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class SingleTopologicalMutationOperator
extends MutationOperator
implements Configurable {
    private static final float DEFAULT_MUTATION_RATE = SingleTopologicalMutationOperator.calculateMutationRate(0.01f, 0.01f);
    private AddConnectionMutationOperator addConnOp;
    private AddNeuronMutationOperator addNeuronOp;
    private double addConnRatio = SingleTopologicalMutationOperator.calculateAddConnRatio(0.01f, 0.01f);

    @Override
    public void init(Properties props) throws Exception {
        this.addConnOp = (AddConnectionMutationOperator)props.singletonObjectProperty(AddConnectionMutationOperator.class);
        this.addNeuronOp = (AddNeuronMutationOperator)props.singletonObjectProperty(AddNeuronMutationOperator.class);
        float addConnRate = this.addConnOp.getMutationRate();
        float addNeuronRate = this.addNeuronOp.getMutationRate();
        this.addConnRatio = SingleTopologicalMutationOperator.calculateAddConnRatio(addConnRate, addNeuronRate);
        this.setMutationRate(SingleTopologicalMutationOperator.calculateMutationRate(addConnRate, addNeuronRate));
    }

    private static double calculateAddConnRatio(float addConnMutationRate, float addNeuronMutationRate) {
        return ((double)addConnMutationRate - (double)(addConnMutationRate * addNeuronMutationRate) * 0.5) / (double)(addConnMutationRate + addNeuronMutationRate);
    }

    private static float calculateMutationRate(float addConnMutationRate, float addNeuronMutationRate) {
        return addConnMutationRate + addNeuronMutationRate - addConnMutationRate * addNeuronMutationRate;
    }

    public SingleTopologicalMutationOperator() {
        super(DEFAULT_MUTATION_RATE);
    }

    public SingleTopologicalMutationOperator(float addConnMutationRate, float addNeuronMutationRate, RecurrencyPolicy aPolicy) {
        super(SingleTopologicalMutationOperator.calculateMutationRate(addConnMutationRate, addNeuronMutationRate));
        this.addConnRatio = SingleTopologicalMutationOperator.calculateAddConnRatio(addConnMutationRate, addNeuronMutationRate);
        this.addConnOp = new AddConnectionMutationOperator(addConnMutationRate, aPolicy);
        this.addNeuronOp = new AddNeuronMutationOperator(addNeuronMutationRate);
    }

    @Override
    protected void mutate(Configuration jgapConfig, ChromosomeMaterial target, Set allelesToAdd, Set allelesToRemove) {
        if (!(jgapConfig instanceof NeatConfiguration)) {
            throw new AnjiRequiredException("com.anji.neat.NeatConfiguration");
        }
        NeatConfiguration config = (NeatConfiguration)jgapConfig;
        Random rand = config.getRandomGenerator();
        if (this.doesMutationOccur(rand)) {
            SortedSet alleles = target.getAlleles();
            if (rand.nextDouble() < this.addConnRatio) {
                List neuronList = NeatChromosomeUtility.getNeuronList(alleles);
                SortedMap conns = NeatChromosomeUtility.getConnectionMap(alleles);
                this.addConnOp.addSingleConnection(config, neuronList, conns, allelesToAdd);
            } else {
                List connList = NeatChromosomeUtility.getConnectionList(alleles);
                Collections.shuffle(connList, rand);
                Iterator iter = connList.iterator();
                boolean isAdded = false;
                while (iter.hasNext() && !isAdded) {
                    ConnectionAllele oldConnectAllele = (ConnectionAllele)iter.next();
                    isAdded = this.addNeuronOp.addNeuronAtConnection(config, NeatChromosomeUtility.getNeuronMap(alleles), oldConnectAllele, allelesToAdd, allelesToRemove);
                }
            }
        }
    }
}

