/*
 * Decompiled with CFR 0.152.
 */
package com.anji.neat;

import com.anji.integration.AnjiRequiredException;
import com.anji.neat.ConnectionAllele;
import com.anji.neat.NeatChromosomeUtility;
import com.anji.neat.NeatConfiguration;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.MutationOperator;

public class WeightMutationOperator
extends MutationOperator
implements Configurable {
    private static final String WEIGHT_MUTATE_RATE_KEY = "weight.mutation.rate";
    private static final String WEIGHT_MUTATE_STD_DEV_KEY = "weight.mutation.std.dev";
    public static final float DEFAULT_MUTATE_RATE = 0.1f;
    public static final float DEFAULT_STD_DEV = 1.0f;
    private float stdDev = 1.0f;

    @Override
    public void init(Properties props) throws Exception {
        this.setMutationRate(props.getFloatProperty(WEIGHT_MUTATE_RATE_KEY, 0.1f));
        this.stdDev = props.getFloatProperty(WEIGHT_MUTATE_STD_DEV_KEY, 1.0f);
    }

    public WeightMutationOperator() {
        super(0.1f);
    }

    public WeightMutationOperator(float newMutationRate) {
        this(newMutationRate, 1.0f);
    }

    public WeightMutationOperator(float newMutationRate, float newStdDev) {
        super(newMutationRate);
        this.stdDev = newStdDev;
    }

    @Override
    protected void mutate(Configuration jgapConfig, ChromosomeMaterial target, Set genesToAdd, Set genesToRemove) {
        if (!(jgapConfig instanceof NeatConfiguration)) {
            throw new AnjiRequiredException(NeatConfiguration.class.toString());
        }
        NeatConfiguration config = (NeatConfiguration)jgapConfig;
        List conns = NeatChromosomeUtility.getConnectionList(target.getAlleles());
        Collections.shuffle(conns, config.getRandomGenerator());
        int numMutations = this.numMutations(config.getRandomGenerator(), conns.size());
        Iterator iter = conns.iterator();
        int i = 0;
        while (i++ < numMutations && iter.hasNext()) {
            ConnectionAllele origAllele = (ConnectionAllele)iter.next();
            double nextWeight = origAllele.getWeight() + config.getRandomGenerator().nextGaussian() * (double)this.getStdDev();
            if (nextWeight > config.getMaxConnectionWeight()) {
                nextWeight = config.getMaxConnectionWeight();
            } else if (nextWeight < config.getMinConnectionWeight()) {
                nextWeight = config.getMinConnectionWeight();
            }
            ConnectionAllele newAllele = (ConnectionAllele)origAllele.cloneAllele();
            newAllele.setWeight(nextWeight);
            genesToRemove.add(origAllele);
            genesToAdd.add(newAllele);
        }
    }

    public float getStdDev() {
        return this.stdDev;
    }
}

