/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.ActivationFunction;
import com.anji.nn.ClampedLinearActivationFunction;
import com.anji.nn.EvSailSigmoidActivationFunction;
import com.anji.nn.InverseAbsActivationFunction;
import com.anji.nn.LinearActivationFunction;
import com.anji.nn.SigmoidActivationFunction;
import com.anji.nn.SignedClampedLinearActivationFunction;
import com.anji.nn.SignedStepActivationFunction;
import com.anji.nn.StepActivationFunction;
import com.anji.nn.TanhActivationFunction;
import com.anji.nn.TanhCubicActivationFunction;
import java.util.HashMap;
import java.util.Map;

public class ActivationFunctionFactory {
    private Map activationFunctions = new HashMap();
    private static ActivationFunctionFactory instance = null;

    private ActivationFunctionFactory() {
        this.activationFunctions.put(LinearActivationFunction.NAME, new LinearActivationFunction());
        this.activationFunctions.put(SigmoidActivationFunction.NAME, new SigmoidActivationFunction());
        this.activationFunctions.put(TanhActivationFunction.NAME, new TanhActivationFunction());
        this.activationFunctions.put(TanhCubicActivationFunction.NAME, new TanhCubicActivationFunction());
        this.activationFunctions.put("evsail-sigmoid", new EvSailSigmoidActivationFunction());
        this.activationFunctions.put("inverse-abs", new InverseAbsActivationFunction());
        this.activationFunctions.put("step", new StepActivationFunction());
        this.activationFunctions.put("signed-step", new SignedStepActivationFunction());
        this.activationFunctions.put(ClampedLinearActivationFunction.NAME, new ClampedLinearActivationFunction());
        this.activationFunctions.put(SignedClampedLinearActivationFunction.NAME, new SignedClampedLinearActivationFunction());
    }

    public static ActivationFunctionFactory getInstance() {
        if (instance == null) {
            instance = new ActivationFunctionFactory();
        }
        return instance;
    }

    public ActivationFunction get(String key) {
        return (ActivationFunction)this.activationFunctions.get(key);
    }

    public ActivationFunction getLinear() {
        return (ActivationFunction)this.activationFunctions.get(LinearActivationFunction.NAME);
    }

    public ActivationFunction getStep() {
        return (ActivationFunction)this.activationFunctions.get("step");
    }

    public ActivationFunction getSignedStep() {
        return (ActivationFunction)this.activationFunctions.get("signed-step");
    }

    public ActivationFunction getSigmoid() {
        return (ActivationFunction)this.activationFunctions.get(SigmoidActivationFunction.NAME);
    }

    public ActivationFunction getEvSailSigmoid() {
        return (ActivationFunction)this.activationFunctions.get("evsail-sigmoid");
    }

    public ActivationFunction getTanh() {
        return (ActivationFunction)this.activationFunctions.get(TanhActivationFunction.NAME);
    }

    public ActivationFunction getTanhCubic() {
        return (ActivationFunction)this.activationFunctions.get(TanhCubicActivationFunction.NAME);
    }

    public ActivationFunction getInverseAbs() {
        return (ActivationFunction)this.activationFunctions.get("inverse-abs");
    }

    public ActivationFunction getClampedLinear() {
        return (ActivationFunction)this.activationFunctions.get(ClampedLinearActivationFunction.NAME);
    }

    public ActivationFunction getSignedClampedLinear() {
        return (ActivationFunction)this.activationFunctions.get(SignedClampedLinearActivationFunction.NAME);
    }
}

