/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.CacheNeuronConnection;
import com.anji.nn.Neuron;
import com.anji.nn.NeuronConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnjiNet {
    public static final String XML_TAG = "network";
    private List allNeurons;
    private List inNeurons;
    private List outNeurons;
    private Collection recurrentConns;
    private String name;

    public AnjiNet(Collection someNeurons, List someInNeurons, List someOutNeurons, Collection someRecurrentConns, String aName) {
        this.init(someNeurons, someInNeurons, someOutNeurons, someRecurrentConns, aName);
    }

    protected AnjiNet() {
    }

    public long cost() {
        long result2 = 0L;
        for (Neuron n : this.allNeurons) {
            result2 += n.cost();
        }
        return result2;
    }

    protected void init(Collection someNeurons, List someInNeurons, List someOutNeurons, Collection someRecurrentConns, String aName) {
        this.allNeurons = new ArrayList(someNeurons);
        this.inNeurons = someInNeurons;
        this.outNeurons = someOutNeurons;
        this.recurrentConns = someRecurrentConns;
        this.name = aName;
    }

    public Neuron getInputNeuron(int idx) {
        return (Neuron)this.inNeurons.get(idx);
    }

    public int getInputDimension() {
        return this.inNeurons.size();
    }

    public Neuron getOutputNeuron(int idx) {
        return (Neuron)this.outNeurons.get(idx);
    }

    public List getOutputNeurons(int fromIdx, int toIdx) {
        return this.outNeurons.subList(fromIdx, toIdx);
    }

    public List getInputNeurons(int fromIdx, int toIdx) {
        return this.inNeurons.subList(fromIdx, toIdx);
    }

    public int getOutputDimension() {
        return this.outNeurons.size();
    }

    public Collection getRecurrentConns() {
        return this.recurrentConns;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void step() {
        for (CacheNeuronConnection c2 : this.recurrentConns) {
            c2.step();
        }
        for (Neuron n : this.allNeurons) {
            n.step();
        }
    }

    public void fullyActivate() {
        for (Neuron n : this.allNeurons) {
            n.getValue();
        }
    }

    public void reset() {
        for (Neuron n : this.allNeurons) {
            n.reset();
        }
        for (CacheNeuronConnection c2 : this.recurrentConns) {
            c2.reset();
        }
    }

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_TAG).append(">\n");
        result2.append("<title>").append(this.getName()).append("</title>\n");
        Neuron.appendToXml(this.allNeurons, this.outNeurons, result2);
        NeuronConnection.appendToXml(this.allNeurons, result2);
        result2.append("</").append(XML_TAG).append(">\n");
        return result2.toString();
    }

    public boolean isRecurrent() {
        return !this.recurrentConns.isEmpty();
    }
}

