/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.Neuron;
import com.anji.nn.NeuronConnection;

public class CacheNeuronConnection
extends NeuronConnection {
    private double value;

    public CacheNeuronConnection(Neuron anIncoming) {
        super(anIncoming);
        this.reset();
    }

    public CacheNeuronConnection(Neuron anIncoming, double aWeight) {
        super(anIncoming, aWeight);
        this.reset();
    }

    @Override
    public double read() {
        return this.value;
    }

    public void step() {
        this.value = Math.min(Math.max(this.getWeight() * this.getIncomingNode().getValue(), -1.7976931348623157E308), Double.MAX_VALUE);
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append("connection").append(" id=\"").append(this.getId());
        result2.append("\" src-id=\"").append(this.getIncomingNode().getId());
        result2.append("\" weight=\"").append(this.getWeight()).append("\" />");
        result2.append("\" recurrent=\"true\" />");
        return result2.toString();
    }

    public void reset() {
        this.value = 0.0;
    }

    @Override
    public boolean isRecurrent() {
        return true;
    }

    @Override
    public long cost() {
        return 159L;
    }
}

