/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.ActivationFunction;

public class EvSailSigmoidActivationFunction
implements ActivationFunction {
    private static final double SEP = 0.3;
    private static final double DENOMINATOR = 0.18;
    public static final String NAME = "evsail-sigmoid";

    public String toString() {
        return NAME;
    }

    EvSailSigmoidActivationFunction() {
    }

    @Override
    public double apply(double input) {
        if (input <= -0.3) {
            return 0.0;
        }
        if (input <= 0.0) {
            double tmp = input + 0.3;
            return tmp * tmp / 0.18;
        }
        if (input < 0.3) {
            double tmp = input - 0.3;
            return 1.0 - tmp * tmp / 0.18;
        }
        return 1.0;
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public long cost() {
        return 166L;
    }
}

