/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.neat.NeuronType;
import com.anji.nn.ActivationFunction;
import com.anji.nn.CacheNeuronConnection;
import com.anji.nn.Connection;
import com.anji.nn.NeuronConnection;
import com.anji.nn.Pattern;
import com.anji.util.XmlPersistable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Neuron
implements XmlPersistable {
    public static final String XML_TAG = "neuron";
    private long id = this.hashCode();
    protected double value;
    private boolean dirty;
    private Collection incomingConns = new ArrayList();
    private ActivationFunction func = null;

    public Neuron(ActivationFunction aFunc) throws IllegalArgumentException {
        if (aFunc == null) {
            throw new IllegalArgumentException("activation function can not be null");
        }
        this.func = aFunc;
        this.reset();
    }

    public void addIncomingConnection(Connection c2) {
        this.incomingConns.add(c2);
    }

    public void step() {
        this.dirty = true;
    }

    public double getValue() {
        if (this.dirty) {
            double sum = 0.0;
            for (Connection conn : this.incomingConns) {
                sum += conn.read();
            }
            this.value = Math.min(Math.max(this.func.apply(sum), -1.7976931348623157E308), Double.MAX_VALUE);
            this.dirty = false;
        }
        return this.value;
    }

    public void reset() {
        this.value = 0.0;
        this.dirty = true;
    }

    public String toString() {
        return Long.toString(this.id);
    }

    @Override
    public String toXml() {
        NeuronMetaData layout = new NeuronMetaData(this);
        return Neuron.toXml(layout);
    }

    public static String toXml(NeuronMetaData layout) {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_TAG).append(" id=\"").append(layout.getId());
        if (layout.getType() != null) {
            result2.append("\" type=\"").append(layout.getType().toString());
        }
        if (layout != null) {
            result2.append("\" hint-layer=\"").append(layout.getHintLayer());
            result2.append("\" hint-position=\"").append(layout.getHintPosition());
        }
        result2.append("\" value=\"").append(layout.getValue());
        result2.append("\" step-pending=\"").append(layout.isDirty());
        result2.append("\" activation=\"").append(layout.getActivationFunction().toString()).append("\" />\n");
        return result2.toString();
    }

    public static void appendToXml(Collection allNeurons, List outputNeurons, StringBuffer result2) {
        TreeMap layerToCoords = new TreeMap();
        int maxLayer = 1;
        ArrayList nonOuputNeurons = new ArrayList(allNeurons);
        nonOuputNeurons.removeAll(outputNeurons);
        HashMap allMetaData = new HashMap();
        for (Neuron n : nonOuputNeurons) {
            NeuronMetaData metaData = Neuron.createMetaData(n, allMetaData);
            if (metaData == null) continue;
            maxLayer = Math.max(maxLayer, metaData.getHintLayer());
            Long layerNum = new Long(metaData.getHintLayer());
            ArrayList<NeuronMetaData> layer = (ArrayList<NeuronMetaData>)layerToCoords.get(layerNum);
            if (layer == null) {
                layer = new ArrayList<NeuronMetaData>();
                layerToCoords.put(layerNum, layer);
            }
            layer.add(metaData);
        }
        Long outLayerNum = new Long(maxLayer + 1);
        ArrayList<NeuronMetaData> outLayer = new ArrayList<NeuronMetaData>();
        layerToCoords.put(outLayerNum, outLayer);
        for (Neuron n : outputNeurons) {
            NeuronMetaData metaData = new NeuronMetaData(n);
            metaData.setHintLayer(outLayerNum.intValue());
            metaData.setHintPosition(n.getId());
            metaData.setType(NeuronType.OUTPUT);
            outLayer.add(metaData);
        }
        for (Long layerNum : layerToCoords.keySet()) {
            List layer = (List)layerToCoords.get(layerNum);
            Collections.sort(layer, NeuronMetaDataPositionComparator.getInstance());
            int i = 0;
            while (i < layer.size()) {
                NeuronMetaData metaData = (NeuronMetaData)layer.get(i);
                metaData.setHintPosition(i + 1);
                result2.append(Neuron.toXml(metaData));
                ++i;
            }
        }
    }

    private static int inputPos(Neuron n) {
        int numInputs = 0;
        int totalPos = 0;
        for (Connection c2 : n.getIncomingConns()) {
            if (!(c2 instanceof Pattern.PatternConnection)) continue;
            Pattern.PatternConnection pc = (Pattern.PatternConnection)c2;
            ++numInputs;
            totalPos += pc.getIdx();
        }
        return numInputs == 0 ? -1 : totalPos / numInputs;
    }

    private static NeuronMetaData createMetaData(Neuron neuron, Map allMetaData) {
        Long id = new Long(neuron.getId());
        NeuronMetaData result2 = (NeuronMetaData)allMetaData.get(id);
        if (result2 != null) {
            return result2;
        }
        result2 = new NeuronMetaData(neuron);
        int anInputPos = Neuron.inputPos(neuron);
        if (anInputPos > -1) {
            result2.setHintLayer(1);
            result2.setHintPosition(anInputPos);
            result2.setType(NeuronType.INPUT);
        } else if (neuron.incomingConns.isEmpty()) {
            result2 = null;
        } else {
            int maxIncomingLayer = 0;
            int numInputs = 0;
            float totalInputPos = 0.0f;
            for (Connection conn : neuron.incomingConns) {
                NeuronConnection nConn;
                Neuron inNeuron;
                NeuronMetaData inMetaData;
                if (!(conn instanceof NeuronConnection) || (inMetaData = Neuron.createMetaData(inNeuron = (nConn = (NeuronConnection)conn).getIncomingNode(), allMetaData)) == null) continue;
                maxIncomingLayer = Math.max(inMetaData.getHintLayer(), maxIncomingLayer);
                ++numInputs;
                totalInputPos += inMetaData.getHintPosition();
            }
            if (numInputs == 0) {
                result2 = null;
            } else {
                result2.setHintLayer(maxIncomingLayer + 1);
                result2.setHintPosition(totalInputPos / (float)numInputs);
                result2.setType(NeuronType.HIDDEN);
            }
        }
        allMetaData.put(id, result2);
        return result2;
    }

    protected Collection getIncomingConns() {
        return this.incomingConns;
    }

    public boolean isRecurrent() {
        for (Connection c2 : this.getIncomingConns()) {
            if (!(c2 instanceof CacheNeuronConnection)) continue;
            return true;
        }
        return false;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ActivationFunction getFunc() {
        return this.func;
    }

    public long cost() {
        long result2 = 315L;
        for (Connection c2 : this.incomingConns) {
            result2 += c2.cost();
            result2 += 115L;
        }
        return result2 += this.func.cost();
    }

    @Override
    public String getXmlRootTag() {
        return XML_TAG;
    }

    @Override
    public String getXmld() {
        return Long.toString(this.id);
    }

    private static class NeuronMetaData {
        private Neuron neuron;
        private float hintPosition;
        private int hintLayer;
        private NeuronType type;

        public NeuronMetaData(Neuron aNeuron) {
            this.neuron = aNeuron;
        }

        public int getHintLayer() {
            return this.hintLayer;
        }

        public float getHintPosition() {
            return this.hintPosition;
        }

        public void setHintLayer(int i) {
            this.hintLayer = i;
        }

        public void setHintPosition(float f) {
            this.hintPosition = f;
        }

        public NeuronType getType() {
            return this.type;
        }

        public void setType(NeuronType aType) {
            this.type = aType;
        }

        public long getId() {
            return this.neuron.getId();
        }

        public boolean isDirty() {
            return this.neuron.isDirty();
        }

        public ActivationFunction getActivationFunction() {
            return this.neuron.getFunc();
        }

        public double getValue() {
            return this.neuron.getValue();
        }
    }

    private static class NeuronMetaDataPositionComparator
    implements Comparator {
        private static NeuronMetaDataPositionComparator instance = null;

        private NeuronMetaDataPositionComparator() {
        }

        public static NeuronMetaDataPositionComparator getInstance() {
            if (instance == null) {
                instance = new NeuronMetaDataPositionComparator();
            }
            return instance;
        }

        public int compare(Object o1, Object o2) {
            NeuronMetaData hc1 = (NeuronMetaData)o1;
            NeuronMetaData hc2 = (NeuronMetaData)o2;
            float result2 = hc1.getHintPosition() - hc2.getHintPosition();
            if (result2 > 0.0f) {
                return 1;
            }
            if (result2 < 0.0f) {
                return -1;
            }
            return 0;
        }
    }
}

