/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.Connection;
import com.anji.nn.Neuron;
import java.util.Collection;

public class NeuronConnection
implements Connection {
    static final String SRC_XML_TAG = "src-id";
    static final String DEST_XML_TAG = "tgt-id";
    static final String WEIGHT_XML_TAG = "weight";
    static final String RECURRENT_XML_TAG = "recurrent";
    private long id = this.hashCode();
    private Neuron incomingNode = null;
    private double weight = 0.0;

    public NeuronConnection(Neuron anIncoming) {
        this(anIncoming, 0.0);
    }

    public NeuronConnection(Neuron anIncoming, double aWeight) {
        this.incomingNode = anIncoming;
        this.weight = aWeight;
    }

    public void setWeight(double f) {
        this.weight = f;
    }

    @Override
    public double read() {
        return this.weight * this.incomingNode.getValue();
    }

    public String toString() {
        return "id: " + this.id + ", src: " + this.incomingNode.getId();
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append("connection").append(" id=\"").append(this.id);
        result2.append("\" ").append(SRC_XML_TAG).append("=\"").append(this.incomingNode.getId());
        result2.append("\" ").append(WEIGHT_XML_TAG).append("=\"").append(this.getWeight());
        result2.append("\" ").append(RECURRENT_XML_TAG).append("=\"").append(this.isRecurrent()).append(" />");
        return result2.toString();
    }

    public void setId(long l) {
        this.id = l;
    }

    protected long getId() {
        return this.id;
    }

    protected Neuron getIncomingNode() {
        return this.incomingNode;
    }

    protected double getWeight() {
        return this.weight;
    }

    public static void appendToXml(Collection allNeurons, StringBuffer result2) {
        for (Neuron neuron : allNeurons) {
            for (Connection conn : neuron.getIncomingConns()) {
                if (!(conn instanceof NeuronConnection)) continue;
                NeuronConnection nConn = (NeuronConnection)conn;
                long srcId = nConn.getIncomingNode().getId();
                result2.append("<").append("connection").append(" ");
                result2.append(SRC_XML_TAG).append("=\"").append(srcId).append("\" ");
                result2.append(DEST_XML_TAG).append("=\"").append(neuron.getId()).append("\" ");
                result2.append(WEIGHT_XML_TAG).append("=\"").append(nConn.getWeight()).append("\" ");
                result2.append(RECURRENT_XML_TAG).append("=\"").append(nConn.isRecurrent()).append("\" />\n");
            }
        }
    }

    public boolean isRecurrent() {
        return false;
    }

    @Override
    public long cost() {
        return 57L;
    }
}

