/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.Connection;
import java.util.Arrays;

public class Pattern {
    public static final String XML_TAG = "pattern";
    protected double[] values = null;
    private PatternConnection[] conns = null;

    public Pattern(int dimension) throws IllegalArgumentException {
        if (dimension <= 0) {
            throw new IllegalArgumentException("dimension must be > 0");
        }
        this.init(new double[dimension]);
    }

    public Pattern(double[] aValues) throws IllegalArgumentException {
        this.init(aValues);
    }

    private void init(double[] aValues) {
        this.values = aValues;
        this.conns = new PatternConnection[aValues.length];
    }

    public void clear() {
        Arrays.fill(this.values, 0.0);
    }

    public void setValues(double[] someValues) throws IllegalArgumentException {
        if (someValues.length != this.values.length) {
            throw new IllegalArgumentException("can not change array dimension");
        }
        this.values = someValues;
    }

    public void setValue(int idx, double value) throws IllegalArgumentException {
        try {
            this.values[idx] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("idx out of bounds");
        }
    }

    public Connection getConnection(int idx) throws IllegalArgumentException {
        try {
            if (this.conns[idx] == null) {
                this.conns[idx] = new PatternConnection(idx);
            }
            return this.conns[idx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("idx out of bounds");
        }
    }

    public int getDimension() {
        return this.values.length;
    }

    public String toString() {
        return com.anji.util.Arrays.toString(this.values);
    }

    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append(XML_TAG).append(">\n");
        int i = 0;
        while (i < this.values.length) {
            result2.append("<value index=\"").append(i).append("\" >").append(this.values[i]).append("</value>\n");
            ++i;
        }
        result2.append("</").append(XML_TAG).append(">\n");
        return result2.toString();
    }

    class PatternConnection
    implements Connection {
        private int idx;

        public PatternConnection(int anIdx) {
            this.idx = anIdx;
        }

        @Override
        public double read() {
            return Pattern.this.values[this.idx];
        }

        @Override
        public String toXml() {
            StringBuffer result2 = new StringBuffer();
            result2.append("<").append("connection");
            result2.append("\" from-input=\"").append(this.idx).append("\" />");
            return result2.toString();
        }

        int getIdx() {
            return this.idx;
        }

        @Override
        public long cost() {
            return 41L;
        }
    }
}

