/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.ActivationFunction;
import com.anji.nn.ActivationFunctionType;

public class SigmoidActivationFunction
implements ActivationFunction {
    private static final double SLOPE = 4.924273;
    public static final String NAME = ActivationFunctionType.SIGMOID.toString();

    public String toString() {
        return NAME;
    }

    SigmoidActivationFunction() {
    }

    @Override
    public double apply(double input) {
        return 1.0 / (1.0 + Math.exp(-(input * 4.924273)));
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public long cost() {
        return 497L;
    }
}

