/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.Connection;

public class StepHourglassConnection
implements Connection {
    private long maxSteps;
    private long stepsRemaining;

    public StepHourglassConnection() {
        this.reset(1);
    }

    public void reset(int aMaxSteps) {
        if (aMaxSteps <= 0) {
            throw new IllegalArgumentException("max steps must be > 0");
        }
        this.stepsRemaining = this.maxSteps = (long)aMaxSteps;
    }

    public void reset() {
        this.stepsRemaining = this.maxSteps;
    }

    @Override
    public double read() {
        return this.stepsRemaining <= 0L ? 0.0 : (double)this.stepsRemaining / (double)this.maxSteps;
    }

    public void step() {
        --this.stepsRemaining;
    }

    public String toString() {
        return new StringBuffer().append(this.stepsRemaining).append("/").append(this.maxSteps).toString();
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer();
        result2.append("<").append("connection").append(" hourglass-steps-remaining=\"");
        result2.append(this.stepsRemaining).append("\" />");
        return result2.toString();
    }

    @Override
    public long cost() {
        return 74L;
    }
}

