/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.ActivationFunction;
import com.anji.nn.ActivationFunctionType;

public class TanhActivationFunction
implements ActivationFunction {
    public static final String NAME = ActivationFunctionType.TANH.toString();

    public String toString() {
        return NAME;
    }

    TanhActivationFunction() {
    }

    @Override
    public double apply(double input) {
        return -1.0 + 2.0 / (1.0 + Math.exp(-2.0 * input));
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return -1.0;
    }

    @Override
    public long cost() {
        return 385L;
    }
}

