/*
 * Decompiled with CFR 0.152.
 */
package com.anji.nn;

import com.anji.nn.ActivationFunction;
import com.anji.nn.ActivationFunctionType;

public class TanhCubicActivationFunction
implements ActivationFunction {
    public static final String NAME = ActivationFunctionType.TANH_CUBIC.toString();

    public String toString() {
        return NAME;
    }

    TanhCubicActivationFunction() {
    }

    @Override
    public double apply(double input) {
        return -1.0 + 2.0 / (1.0 + Math.exp(Math.pow(-input, 3.0)));
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return -1.0;
    }

    @Override
    public long cost() {
        return 1231L;
    }
}

