/*
 * Decompiled with CFR 0.152.
 */
package com.anji.persistence;

import com.anji.integration.Activator;
import com.anji.integration.XmlPersistableAllele;
import com.anji.integration.XmlPersistableChromosome;
import com.anji.integration.XmlPersistableRun;
import com.anji.persistence.Persistence;
import com.anji.run.Run;
import com.anji.util.Properties;
import com.anji.util.XmlPersistable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jgap.Allele;
import org.jgap.Chromosome;
import org.jgap.ChromosomeMaterial;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FilePersistence
implements Persistence {
    private static final Logger logger = Logger.getLogger(FilePersistence.class);
    public static final String BASE_DIR_KEY = "base.dir";
    private File baseDir = null;
    private String runId = null;

    @Override
    public void init(Properties props) {
        String baseDirStr = props.getProperty(BASE_DIR_KEY);
        this.baseDir = new File(baseDirStr);
        this.baseDir.mkdirs();
        if (!this.baseDir.exists()) {
            throw new IllegalArgumentException("base directory does not exist: " + baseDirStr);
        }
        if (!this.baseDir.isDirectory()) {
            throw new IllegalArgumentException("base directory is a file: " + baseDirStr);
        }
        if (!this.baseDir.canWrite()) {
            throw new IllegalArgumentException("base directory not writable: " + baseDirStr);
        }
    }

    private InputStream loadStream(String type, String key) throws IOException {
        return new FileInputStream(this.fullPath(type, key));
    }

    private void storeXml(XmlPersistable xp) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this.fullPath(xp.getXmlRootTag(), xp.getXmld()));
            out.write(xp.toXml().getBytes());
            out.close();
        }
    }

    protected String fullPath(String type, String key) {
        StringBuffer result2 = new StringBuffer(this.baseDir.getAbsolutePath());
        result2.append(File.separatorChar).append(type);
        File collectionDir = new File(result2.toString());
        if (!collectionDir.isDirectory()) {
            if (collectionDir.exists()) {
                throw new IllegalArgumentException(String.valueOf(result2.toString()) + " is a file");
            }
            collectionDir.mkdir();
        }
        result2.append(File.separatorChar).append(type).append(key).append(".xml");
        return result2.toString();
    }

    @Override
    public void reset() {
        this.reset(Priority.DEBUG);
    }

    private void reset(Priority pri) {
        File[] dirs = this.baseDir.listFiles();
        int i = 0;
        while (i < dirs.length) {
            File dir = dirs[i];
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                int j = 0;
                while (j < files.length) {
                    File file = files[j];
                    String msg = file.delete() ? "file deleted: " : "error deleting file: ";
                    msg = String.valueOf(msg) + file.getAbsolutePath();
                    logger.log(pri, msg);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void deleteXml(String type, String key) throws Exception {
        File file = new File(this.fullPath(type, key));
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void store(Chromosome c2) throws Exception {
        this.storeXml(new XmlPersistableChromosome(c2));
    }

    @Override
    public void store(Activator a2) throws Exception {
        this.storeXml(a2);
    }

    @Override
    public void store(Run r) throws Exception {
        this.storeXml(new XmlPersistableRun(r));
    }

    public static Chromosome chromosomeFromXml(Configuration config, String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(in);
        return FilePersistence.chromosomeFromXml(config, doc.getFirstChild());
    }

    public static Chromosome chromosomeFromXml(Configuration config, Node chromNode) {
        String idStr;
        String idStr2;
        String idStr3;
        if (!"chromosome".equals(chromNode.getNodeName())) {
            throw new IllegalArgumentException("node name not chromosome");
        }
        ArrayList<Allele> genes = new ArrayList<Allele>();
        NodeList geneNodes = chromNode.getChildNodes();
        int i = 0;
        while (i < geneNodes.getLength()) {
            Node geneNode = geneNodes.item(i);
            if ("neuron".equals(geneNode.getNodeName())) {
                genes.add(XmlPersistableAllele.neuronFromXml(geneNode));
            } else if ("connection".equals(geneNode.getNodeName())) {
                genes.add(XmlPersistableAllele.connectionFromXml(geneNode));
            }
            ++i;
        }
        Long id = null;
        Node idNode = chromNode.getAttributes().getNamedItem("id");
        if (idNode != null && (idStr3 = idNode.getNodeValue()) != null && idStr3.length() > 0) {
            id = Long.valueOf(idStr3);
        }
        Long primaryParentId = null;
        idNode = chromNode.getAttributes().getNamedItem("primary-parent-id");
        if (idNode != null && (idStr2 = idNode.getNodeValue()) != null && idStr2.length() > 0) {
            primaryParentId = Long.valueOf(idStr2);
        }
        Long secondaryParentId = null;
        idNode = chromNode.getAttributes().getNamedItem("secondary-parent-id");
        if (idNode != null && (idStr = idNode.getNodeValue()) != null && idStr.length() > 0) {
            secondaryParentId = Long.valueOf(idStr);
        }
        ChromosomeMaterial material = new ChromosomeMaterial(genes, primaryParentId, secondaryParentId);
        return id == null ? new Chromosome(material, config.nextChromosomeId()) : new Chromosome(material, id);
    }

    @Override
    public Chromosome loadChromosome(String id, Configuration config) {
        try {
            InputStream in = this.loadStream("chromosome", id);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            return FilePersistence.chromosomeFromXml(config, doc.getFirstChild());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            String msg = "error loading chromosome " + id;
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }

    @Override
    public void deleteChromosome(String id) throws Exception {
        this.deleteXml("chromosome", id);
    }

    @Override
    public Genotype loadGenotype(Configuration config) {
        try {
            InputStream in = this.loadStream("run", this.runId);
            return this.genotypeFromRunXml(in, config);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            String msg = "error loading run " + this.runId;
            logger.error(msg, e);
            throw new IllegalStateException(String.valueOf(msg) + ": " + e);
        }
    }

    private Genotype genotypeFromRunXml(InputStream runXml, Configuration config) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(runXml, this.baseDir.getAbsolutePath());
        Node runNode = doc.getFirstChild();
        if (!"run".equals(runNode.getNodeName())) {
            throw new IllegalArgumentException("node name not run");
        }
        Node generationNode = null;
        int i = 0;
        while (i < runNode.getChildNodes().getLength()) {
            Node nextNode = runNode.getChildNodes().item(i);
            if ("generation".equals(nextNode.getNodeName())) {
                generationNode = nextNode;
            }
            ++i;
        }
        return FilePersistence.genotypeFromXml(generationNode, config, this);
    }

    private static Genotype genotypeFromXml(Node generationNode, Configuration config, Persistence db) throws Exception {
        if (!"generation".equals(generationNode.getNodeName())) {
            throw new IllegalArgumentException("node name not generation");
        }
        ArrayList<Chromosome> chroms = new ArrayList<Chromosome>();
        int generationChildIdx = 0;
        while (generationChildIdx < generationNode.getChildNodes().getLength()) {
            Node specieNode = generationNode.getChildNodes().item(generationChildIdx);
            if ("specie".equals(specieNode.getNodeName())) {
                NamedNodeMap specieAttrs = specieNode.getAttributes();
                if (specieAttrs == null) {
                    throw new IllegalArgumentException("missing specie attributes");
                }
                int specieChildIdx = 0;
                while (specieChildIdx < specieNode.getChildNodes().getLength()) {
                    Node chromNode = specieNode.getChildNodes().item(specieChildIdx);
                    if ("chromosome".equals(chromNode.getNodeName())) {
                        NamedNodeMap chromAttrs = chromNode.getAttributes();
                        if (chromAttrs == null) {
                            throw new IllegalArgumentException("missing chromosome attributes");
                        }
                        Node chromIdNode = chromAttrs.getNamedItem("id");
                        if (chromIdNode == null) {
                            throw new IllegalArgumentException("missing chromosome id");
                        }
                        Long chromId = Long.valueOf(chromIdNode.getNodeValue());
                        Chromosome c2 = db.loadChromosome(chromId.toString(), config);
                        if (c2 != null) {
                            chroms.add(c2);
                        } else {
                            logger.warn("chromosome in run not found: " + chromId);
                        }
                    }
                    ++specieChildIdx;
                }
            }
            ++generationChildIdx;
        }
        if (chroms.size() <= 0) {
            return null;
        }
        Collections.sort(chroms);
        return new Genotype(config, chroms);
    }

    @Override
    public void startRun(String aRunId) {
        this.runId = aRunId;
    }
}

