/*
 * Decompiled with CFR 0.152.
 */
package com.anji.polebalance;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class PoleBalanceCanvas
extends Canvas {
    private double trackLength;
    private double trackLengthHalf;
    private double[] poleLengths;
    private double cartPos = 0.0;
    private double[] poleAngles;
    private double maxPoleLength = 0.0;
    private static final int DISPLAY_CART_WIDTH = 20;
    private static final int DISPLAY_CART_HEIGHT = 5;

    @Override
    public void paint(Graphics g) {
        Color orig = g.getColor();
        int displayTrackLength = (int)((double)this.getWidth() * 0.8);
        double scaleRatio = (double)displayTrackLength / this.trackLength;
        g.setColor(Color.BLACK);
        int displayTrackYPos = (int)((double)this.getHeight() * 0.9);
        int displayTrackLeftXPos = this.getWidth() / 2 - displayTrackLength / 2;
        g.drawLine(displayTrackLeftXPos, displayTrackYPos, displayTrackLeftXPos + displayTrackLength, displayTrackYPos);
        g.setColor(Color.MAGENTA);
        int displayCartCenterXPos = displayTrackLeftXPos + (int)((double)displayTrackLength * ((this.cartPos + this.trackLengthHalf) / this.trackLength));
        int displayCartLeftXPos = (int)((double)displayCartCenterXPos - 10.0);
        g.fillRect(displayCartLeftXPos, displayTrackYPos - 5, 20, 5);
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.BLUE);
        colors.add(Color.CYAN);
        int i = 0;
        while (i < this.poleAngles.length) {
            g.setColor((Color)colors.get(i));
            double displayPoleLength = this.poleLengths[i] * scaleRatio;
            double radians = this.poleAngles[i] * Math.PI;
            double x = Math.sin(radians) * displayPoleLength;
            double y = Math.cos(radians) * displayPoleLength;
            g.drawLine(displayCartCenterXPos, displayTrackYPos - 5, (int)((double)displayCartCenterXPos + x), (int)((double)(displayTrackYPos - 5) - y));
            ++i;
        }
        g.setColor(orig);
    }

    public PoleBalanceCanvas(double aTrackLength, double[] aPoleLengths) {
        this.trackLength = aTrackLength;
        this.trackLengthHalf = this.trackLength / 2.0;
        this.poleLengths = aPoleLengths;
        this.poleAngles = new double[this.poleLengths.length];
        int i = 0;
        while (i < this.poleLengths.length) {
            if (this.poleLengths[i] > this.maxPoleLength) {
                this.maxPoleLength = this.poleLengths[i];
            }
            this.poleAngles[i] = 0.0;
            ++i;
        }
    }

    public void step(double aCartPos, double[] aPoleAngles) {
        if (this.poleLengths.length != aPoleAngles.length) {
            throw new IllegalArgumentException("wrong # poles, expected " + this.poleLengths.length + ", got " + aPoleAngles.length);
        }
        if (aCartPos < -this.trackLengthHalf || aCartPos > this.trackLengthHalf) {
            throw new IllegalArgumentException("wrong cart pos, expected abs < " + this.trackLengthHalf + ", got " + aCartPos);
        }
        this.cartPos = aCartPos;
        this.poleAngles = aPoleAngles;
    }
}

