/*
 * Decompiled with CFR 0.152.
 */
package com.anji.polebalance;

import com.anji.polebalance.PoleBalanceCanvas;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JSlider;

public class PoleBalanceDisplay
extends JFrame {
    private static final String NAME = "Pole Balance Display";
    private PoleBalanceCanvas poleBalanceCanvas;
    private static final int CANVAS_WIDTH = 300;
    private static final int CANVAS_HEIGHT = 75;
    private static final int SPEED_CONTROL_MIDPOINT = 20;
    private int maxSteps;
    private JSlider speedControl;
    private JProgressBar progressBar;

    public PoleBalanceDisplay(double aTrackLength, double[] aPoleLengths, int aMaxSteps) {
        super(NAME);
        this.init(aTrackLength, aPoleLengths, aMaxSteps);
    }

    private void init(double aTrackLength, double[] aPoleLengths, int aMaxSteps) {
        this.maxSteps = aMaxSteps;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PoleBalanceDisplay.this.setVisible(false);
                PoleBalanceDisplay.this.dispose();
            }
        });
        GridLayout mainLayout = new GridLayout(2, 1);
        mainLayout.setHgap(10);
        mainLayout.setVgap(10);
        this.getContentPane().setLayout(mainLayout);
        GridLayout topPanelLayout = new GridLayout(2, 1);
        topPanelLayout.setHgap(10);
        topPanelLayout.setVgap(10);
        Panel topPanel = new Panel(topPanelLayout);
        this.speedControl = new JSlider(0, 0, 40, 20);
        this.speedControl.setName("Speed");
        this.progressBar = new JProgressBar(0, 0, this.maxSteps);
        this.progressBar.setName("Steps");
        this.progressBar.setValue(0);
        this.poleBalanceCanvas = new PoleBalanceCanvas(aTrackLength, aPoleLengths);
        this.poleBalanceCanvas.setSize(new Dimension(600, 75));
        topPanel.add(this.speedControl);
        topPanel.add(this.progressBar);
        this.getContentPane().add(topPanel);
        this.getContentPane().add(this.poleBalanceCanvas);
        this.pack();
    }

    public void step(int currentStep, double aCartPos, double[] aPoleAngles) {
        int stepsToSleep = this.speedControl.getMaximum() - this.speedControl.getValue();
        if (stepsToSleep > 0) {
            try {
                Thread.sleep(stepsToSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.progressBar.setValue(currentStep);
        this.poleBalanceCanvas.step(aCartPos, aPoleAngles);
        this.poleBalanceCanvas.repaint();
    }

    @Override
    public String toString() {
        return NAME;
    }
}

