/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.nn.AnjiNet;
import com.anji.nn.BiasConnection;
import com.anji.nn.Pattern;
import com.anji.nn.StepHourglassConnection;
import com.anji.roshambo.RoshamboPlayer;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;

public class AnjiNetRoshamboPlayer
implements RoshamboPlayer {
    private static final Logger logger = Logger.getLogger(AnjiNetRoshamboPlayer.class);
    private AnjiNet net;
    private StepHourglassConnection hourglassConnection = new StepHourglassConnection();
    private Random rand;
    private int activationCycles = 1;
    private double[] history;
    private double[] previousResult = new double[1];

    public AnjiNetRoshamboPlayer(AnjiNet aNet, Random aRand, int anActivationCycles, int aHistorySize) {
        int historyInputCount = aHistorySize * 3;
        int expectedInputDimension = historyInputCount + 3;
        if (aNet.getInputDimension() < expectedInputDimension) {
            throw new IllegalArgumentException("Roshambo requires " + expectedInputDimension + "  inputs");
        }
        if (aNet.getInputDimension() > expectedInputDimension) {
            logger.warn("more inputs (" + aNet.getInputDimension() + ") than expected (" + expectedInputDimension + ")");
        }
        if (aNet.getOutputDimension() < 3) {
            throw new IllegalArgumentException("Roshambo scanner requires 3 outputs");
        }
        if (aNet.getOutputDimension() > 3) {
            logger.warn("more outputs (" + aNet.getOutputDimension() + ") than expected (3)");
        }
        this.net = aNet;
        this.rand = aRand;
        this.activationCycles = anActivationCycles;
        this.history = new double[historyInputCount];
        Pattern historyPattern = new Pattern(this.history);
        Pattern prevResultPattern = new Pattern(this.previousResult);
        int i = 0;
        while (i < historyPattern.getDimension()) {
            this.net.getInputNeuron(i).addIncomingConnection(historyPattern.getConnection(i));
            ++i;
        }
        this.net.getInputNeuron(i++).addIncomingConnection(prevResultPattern.getConnection(0));
        this.net.getInputNeuron(i++).addIncomingConnection(this.hourglassConnection);
        this.net.getInputNeuron(i++).addIncomingConnection(BiasConnection.getInstance());
    }

    public AnjiNetRoshamboPlayer(AnjiNet aNet) {
        this(aNet, 1);
    }

    public AnjiNetRoshamboPlayer(AnjiNet aNet, Random aRand) {
        this(aNet, aRand, 1, 1);
    }

    public AnjiNetRoshamboPlayer(AnjiNet aNet, int anActivationCycles) {
        this(aNet, null, anActivationCycles, 1);
    }

    @Override
    public void reset(int aTrials) {
        this.net.reset();
        this.hourglassConnection.reset(aTrials);
        Arrays.fill(this.history, 0.0);
        this.previousResult[0] = 0.0;
    }

    @Override
    public void reset() {
        this.net.reset();
        this.hourglassConnection.reset();
        Arrays.fill(this.history, 0.0);
        this.previousResult[0] = 0.0;
    }

    static void updateHistory(double[] aHistory, int aMove) {
        int i = 3;
        while (i < aHistory.length - 1) {
            aHistory[i - 3] = aHistory[i];
            ++i;
        }
        aHistory[aHistory.length - 3] = aMove == 0 ? 1.0 : 0.0;
        aHistory[aHistory.length - 2] = aMove == 1 ? 1.0 : 0.0;
        aHistory[aHistory.length - 1] = aMove == 2 ? 1.0 : 0.0;
    }

    @Override
    public void storeMove(int aMove, int aScore) {
        AnjiNetRoshamboPlayer.updateHistory(this.history, aMove);
        this.previousResult[0] = aScore;
    }

    @Override
    public int nextMove() {
        int i = 0;
        while (i < this.activationCycles) {
            this.net.step();
            this.net.fullyActivate();
            ++i;
        }
        this.hourglassConnection.step();
        return AnjiNetRoshamboPlayer.calculateMove(this.net.getOutputNeuron(0).getValue(), this.net.getOutputNeuron(1).getValue(), this.net.getOutputNeuron(2).getValue(), this.rand);
    }

    static int calculateMove(double rockAffinity, double paperAffinity, double scissorsAffinity, Random rand) {
        int result2 = 2;
        if (rand == null) {
            if (rockAffinity > scissorsAffinity) {
                if (rockAffinity > paperAffinity) {
                    result2 = 0;
                }
            } else if (paperAffinity > scissorsAffinity) {
                result2 = 1;
            }
        } else {
            double totalAffinity = Math.max(0.0, rockAffinity) + Math.max(0.0, paperAffinity) + Math.max(0.0, scissorsAffinity);
            double prob = rand.nextDouble() * totalAffinity;
            if (prob < rockAffinity) {
                result2 = 0;
            } else if (prob < rockAffinity + paperAffinity) {
                result2 = 1;
            }
        }
        return result2;
    }

    @Override
    public String getPlayerId() {
        return this.net.getName();
    }

    public String toString() {
        return this.net.getName();
    }

    @Override
    public String getAuthor() {
        return "Derek James & Philip Tucker";
    }
}

