/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.nn.ActivationFunction;
import com.anji.nn.AnjiNet;
import com.anji.nn.BiasConnection;
import com.anji.nn.Pattern;
import com.anji.nn.StepHourglassConnection;
import com.anji.roshambo.AnjiNetRoshamboPlayer;
import com.anji.roshambo.RoshamboPlayer;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;

public class AnjiNetScanningRoshamboPlayer
implements RoshamboPlayer {
    private static final Logger logger = Logger.getLogger(AnjiNetScanningRoshamboPlayer.class);
    private static final int MAX_SCANNING_WINDOW_MOVE_PER_STEP = 3;
    private static final int SCANNING_WINDOW_MOVE_OUTPUT_IDX = 3;
    private double scanningWindowMovementOutputMid = 0.0;
    private double scanningWindowMovementOutputMaxAbs = 1.0;
    private AnjiNet net;
    private StepHourglassConnection hourglassConnection = new StepHourglassConnection();
    private Random rand;
    private int activationCycles = 1;
    private double[] history;
    private double[] scanningWindow;
    private double[] previousResult = new double[1];
    private int scanningWindowPos;
    private int scanningWindowPosMax;

    public AnjiNetScanningRoshamboPlayer(AnjiNet aNet, Random aRand, int anActivationCycles, int aHistorySize, int aScanningWindowSize) {
        int scanningWindowInputCount = aScanningWindowSize * 3;
        int expectedInputDimension = scanningWindowInputCount + 3;
        if (aNet.getInputDimension() < expectedInputDimension) {
            throw new IllegalArgumentException("Roshambo requires " + expectedInputDimension + "  inputs");
        }
        if (aNet.getInputDimension() > expectedInputDimension) {
            logger.warn("more inputs (" + aNet.getInputDimension() + ") than expected (" + expectedInputDimension + ")");
        }
        if (aNet.getOutputDimension() < 4) {
            throw new IllegalArgumentException("Roshambo scanner requires 4 outputs");
        }
        if (aNet.getOutputDimension() > 4) {
            logger.warn("more outputs (" + aNet.getOutputDimension() + ") than expected (4)");
        }
        if (aScanningWindowSize >= aHistorySize) {
            throw new IllegalArgumentException("scanning window size " + aScanningWindowSize + " must be smaller than history size " + aHistorySize);
        }
        ActivationFunction movementOutputFunction = aNet.getOutputNeuron(3).getFunc();
        this.scanningWindowMovementOutputMid = (movementOutputFunction.getMaxValue() + movementOutputFunction.getMinValue()) / 2.0;
        this.scanningWindowMovementOutputMaxAbs = movementOutputFunction.getMaxValue() - this.scanningWindowMovementOutputMid;
        this.net = aNet;
        this.rand = aRand;
        this.activationCycles = anActivationCycles;
        this.history = new double[aHistorySize * 3];
        this.previousResult[0] = 0.0;
        Pattern prevResultPattern = new Pattern(this.previousResult);
        this.scanningWindow = new double[scanningWindowInputCount];
        Pattern scanningWindowPattern = new Pattern(this.scanningWindow);
        this.scanningWindowPos = this.scanningWindowPosMax = this.history.length - this.scanningWindow.length;
        int i = 0;
        while (i < scanningWindowPattern.getDimension()) {
            this.net.getInputNeuron(i).addIncomingConnection(scanningWindowPattern.getConnection(i));
            ++i;
        }
        this.net.getInputNeuron(i++).addIncomingConnection(prevResultPattern.getConnection(0));
        this.net.getInputNeuron(i++).addIncomingConnection(this.hourglassConnection);
        this.net.getInputNeuron(i++).addIncomingConnection(BiasConnection.getInstance());
    }

    public AnjiNetScanningRoshamboPlayer(AnjiNet aNet) {
        this(aNet, 1);
    }

    public AnjiNetScanningRoshamboPlayer(AnjiNet aNet, Random aRand) {
        this(aNet, aRand, 1, 1, 0);
    }

    public AnjiNetScanningRoshamboPlayer(AnjiNet aNet, int anActivationCycles) {
        this(aNet, null, anActivationCycles, 1, 0);
    }

    @Override
    public void reset(int aTrials) {
        this.net.reset();
        this.hourglassConnection.reset(aTrials);
        Arrays.fill(this.history, 0.0);
        this.previousResult[0] = 0.0;
    }

    @Override
    public void reset() {
        this.net.reset();
        this.hourglassConnection.reset();
        Arrays.fill(this.history, 0.0);
        this.previousResult[0] = 0.0;
    }

    @Override
    public void storeMove(int aMove, int aScore) {
        AnjiNetRoshamboPlayer.updateHistory(this.history, aMove);
        this.updateScanningWindow();
        this.previousResult[0] = aScore;
    }

    private void updateScanningWindow() {
        double value = this.net.getOutputNeuron(3).getValue();
        double relativeMovementDelta = (value - this.scanningWindowMovementOutputMid) / this.scanningWindowMovementOutputMaxAbs;
        int absMovementDelta = (int)Math.round(relativeMovementDelta * 3.0);
        this.scanningWindowPos += absMovementDelta * 3;
        this.scanningWindowPos = Math.max(this.scanningWindowPos, 0);
        this.scanningWindowPos = Math.min(this.scanningWindowPos, this.scanningWindowPosMax);
        int i = 0;
        while (i < this.scanningWindow.length) {
            this.scanningWindow[i] = this.history[i + this.scanningWindowPos];
            ++i;
        }
    }

    @Override
    public int nextMove() {
        int i = 0;
        while (i < this.activationCycles) {
            this.net.step();
            this.net.fullyActivate();
            this.updateScanningWindow();
            ++i;
        }
        this.hourglassConnection.step();
        return AnjiNetRoshamboPlayer.calculateMove(this.net.getOutputNeuron(0).getValue(), this.net.getOutputNeuron(1).getValue(), this.net.getOutputNeuron(2).getValue(), this.rand);
    }

    @Override
    public String getPlayerId() {
        return this.net.getName();
    }

    public String toString() {
        return this.net.getName();
    }

    @Override
    public String getAuthor() {
        return "Derek James & Philip Tucker";
    }
}

