/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;
import java.util.Arrays;

public class EnigmaPlayer
implements RoshamboPlayer {
    int games = 0;
    int numberOfGames = 0;
    int moves = 0;
    int randomMoves = 0;
    int moveType = 0;
    int lookBack = 1;
    int lookBackSize = 16;
    byte[][] results;
    byte myMove = 0;
    int wins = 0;
    int who = 0;
    int score = 0;
    int[] myDistribution = new int[3];
    int myDistSize = 0;
    int[] playDistribution = new int[3];

    @Override
    public void reset(int trials) {
        this.results = new byte[4][trials + 1];
        this.wins = 0;
        this.lookBack = 1;
        this.moveType = 0;
        this.randomMoves = 40 * trials / 100;
        if (trials < 100) {
            this.lookBackSize = 3;
            this.randomMoves = 5;
        } else {
            this.lookBackSize = 16;
        }
        this.numberOfGames = trials;
        this.games = 0;
        this.moves = 0;
        Arrays.fill(this.myDistribution, 0);
        Arrays.fill(this.playDistribution, 0);
        this.myDistSize = 0;
        this.myMove = 0;
        this.score = 0;
        this.who = 0;
    }

    @Override
    public void reset() {
        this.reset(this.numberOfGames);
    }

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public void storeMove(int opMove, int result2) {
        this.results[0][this.games] = this.myMove;
        this.results[1][this.games] = (byte)opMove;
        this.results[2][this.games] = (byte)result2;
        this.results[3][this.games] = (byte)this.who;
        ++this.games;
        this.score += result2;
        if (result2 >= 0) {
            ++this.wins;
        }
        this.moveType = this.games < this.randomMoves ? 0 : (this.games > this.numberOfGames - this.randomMoves ? 2 : 1);
        if (this.moveType >= 1) {
            ++this.myDistSize;
            byte by = this.myMove;
            this.myDistribution[by] = this.myDistribution[by] + 1;
        }
    }

    @Override
    public int nextMove() {
        double pPaper = 0.3333333333333333;
        double pRock = 0.3333333333333333;
        switch (this.moveType) {
            case 0: {
                this.myMove = (byte)Coin.flip(0.3333333333333333, 0.3333333333333333);
                break;
            }
            case 1: {
                ++this.lookBack;
                if (this.lookBack > this.lookBackSize) {
                    this.lookBack = 1;
                }
                this.who = this.score >= 0 ? Coin.flip(0.3, 0.7) : Coin.flip(0.7, 0.3);
                int i = 0;
                while (i < 3) {
                    this.playDistribution[i] = 0;
                    ++i;
                }
                int g = this.games - this.lookBack - 1;
                while (g < this.games - 1) {
                    byte by = this.results[this.who][g];
                    this.playDistribution[by] = this.playDistribution[by] + 1;
                    ++g;
                }
                pRock = (double)(this.lookBack - this.playDistribution[1]) / (2.0 * (double)this.lookBack);
                pPaper = (double)(this.lookBack - this.playDistribution[2]) / (2.0 * (double)this.lookBack);
                this.myMove = (byte)Coin.flip(pRock, pPaper);
                break;
            }
            case 2: {
                if (this.myDistSize <= 0) break;
                pRock = (double)(this.myDistSize - this.myDistribution[0]) / (2.0 * (double)this.myDistSize);
                pPaper = (double)(this.myDistSize - this.myDistribution[1]) / (2.0 * (double)this.myDistSize);
                this.myMove = (byte)Coin.flip(pRock, pPaper);
            }
        }
        return this.myMove;
    }

    @Override
    public String getPlayerId() {
        return "Enigma 0.1";
    }

    @Override
    public String getAuthor() {
        return "Michael, Matt & Jim - South Pasadena, CA";
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }
}

