/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;

public class IocainePlayer
implements RoshamboPlayer {
    static final int[] ages = new int[]{1000, 100, 10, 5, 2, 1};
    static final int num_ages = ages.length;
    static final int my_hist = 0;
    static final int opp_hist = 1;
    static final int both_hist = 2;
    int[] my_history;
    int[] opp_history;
    int lastmove;
    int trials;
    int[] bestmove;
    int[] best_length;
    result mres;
    predict[][][] pr_history;
    predict[][] pr_freq;
    predict[] pr_meta;
    predict pr_fixed;
    predict pr_random;
    stat[] stats;

    int match_single(int i, int num, int[] history) {
        int high = num;
        int low = i;
        while (low > 0 && history[low] == history[high]) {
            --low;
            --high;
        }
        return num - high;
    }

    int match_both(int i, int num) {
        int j = 0;
        while (j < i && this.opp_history[num - j] == this.opp_history[i - j] && this.my_history[num - j] == this.my_history[i - j]) {
            ++j;
        }
        return j;
    }

    void do_history(int age, int[] best) {
        int j;
        int num = this.my_history[0];
        int w = 0;
        while (w < 3) {
            this.best_length[w] = 0;
            best[w] = 0;
            ++w;
        }
        int i = num - 1;
        while (i > num - age && i > this.best_length[0]) {
            j = this.match_single(i, num, this.my_history);
            if (j > this.best_length[0]) {
                this.best_length[0] = j;
                best[0] = i;
                if (j > num / 2) break;
            }
            --i;
        }
        i = num - 1;
        while (i > num - age && i > this.best_length[1]) {
            j = this.match_single(i, num, this.opp_history);
            if (j > this.best_length[1]) {
                this.best_length[1] = j;
                best[1] = i;
                if (j > num / 2) break;
            }
            --i;
        }
        i = num - 1;
        while (i > num - age && i > this.best_length[2]) {
            j = this.match_both(i, num);
            if (j > this.best_length[2]) {
                this.best_length[2] = j;
                best[2] = i;
                if (j > num / 2) break;
            }
            --i;
        }
    }

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public void reset() {
        this.reset(this.trials);
    }

    @Override
    public void reset(int aTrials) {
        this.my_history = new int[aTrials + 1];
        this.opp_history = new int[aTrials + 1];
        this.opp_history[0] = 0;
        this.my_history[0] = 0;
        this.lastmove = 0;
        this.trials = aTrials;
        this.pr_history = new predict[num_ages][3][2];
        this.pr_freq = new predict[num_ages][2];
        this.pr_meta = new predict[num_ages];
        this.stats = new stat[2];
        int i = 0;
        while (i < num_ages) {
            this.pr_meta[i] = new predict();
            int j = 0;
            while (j < 2) {
                this.pr_freq[i][j] = new predict();
                int k = 0;
                while (k < 3) {
                    this.pr_history[i][k][j] = new predict();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.stats[0] = new stat();
        this.stats[1] = new stat();
        this.pr_fixed = new predict();
        this.pr_random = new predict();
        this.mres = new result();
        this.bestmove = new int[3];
        this.best_length = new int[3];
    }

    @Override
    public void storeMove(int move, int score) {
        this.opp_history[0] = this.opp_history[0] + 1;
        this.opp_history[this.opp_history[0]] = move;
        this.my_history[0] = this.my_history[0] + 1;
        this.my_history[this.my_history[0]] = this.lastmove;
    }

    @Override
    public int nextMove() {
        int num = this.my_history[0];
        int last = num > 0 ? this.opp_history[num] : -1;
        int guess = Coin.flip();
        if (num > 0) {
            this.stats[0].add(this.my_history[num], 1);
            this.stats[1].add(this.opp_history[num], 1);
        }
        int a2 = 0;
        while (a2 < num_ages) {
            this.do_history(ages[a2], this.bestmove);
            int w = 0;
            while (w < 3) {
                int b2 = this.bestmove[w];
                if (b2 == 0) {
                    this.pr_history[a2][w][0].do_predict(last, guess);
                    this.pr_history[a2][w][1].do_predict(last, guess);
                } else {
                    this.pr_history[a2][w][0].do_predict(last, this.my_history[b2 + 1]);
                    this.pr_history[a2][w][1].do_predict(last, this.opp_history[b2 + 1]);
                }
                ++w;
            }
            int p = 0;
            while (p < 2) {
                this.mres.score = -1;
                if (this.stats[p].max(ages[a2], this.mres)) {
                    this.pr_freq[a2][p].do_predict(last, this.mres.move);
                } else {
                    this.pr_freq[a2][p].do_predict(last, guess);
                }
                ++p;
            }
            ++a2;
        }
        this.pr_random.do_predict(last, guess);
        this.pr_fixed.do_predict(last, 0);
        a2 = 0;
        while (a2 < num_ages) {
            this.mres.score = -1;
            this.mres.move = -1;
            int aa = 0;
            while (aa < num_ages) {
                int p = 0;
                while (p < 2) {
                    int w = 0;
                    while (w < 3) {
                        this.pr_history[aa][w][p].scan(ages[a2], this.mres);
                        ++w;
                    }
                    this.pr_freq[aa][p].scan(ages[a2], this.mres);
                    ++p;
                }
                ++aa;
            }
            this.pr_random.scan(ages[a2], this.mres);
            this.pr_fixed.scan(ages[a2], this.mres);
            this.pr_meta[a2].do_predict(last, this.mres.move);
            ++a2;
        }
        this.mres.score = -1;
        this.mres.move = -1;
        a2 = 0;
        while (a2 < num_ages) {
            this.pr_meta[a2].scan(this.trials, this.mres);
            ++a2;
        }
        this.lastmove = this.mres.move;
        return this.mres.move;
    }

    @Override
    public String getPlayerId() {
        return "Iocaine Powder";
    }

    @Override
    public String getAuthor() {
        return "Dan Egnor";
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }

    class predict {
        stat st;
        int last;

        predict() {
            this.st = new stat();
            this.last = -1;
        }

        void do_predict(int olast, int guess) {
            if (-1 != olast) {
                int diff = (3 + olast % 3 - this.last % 3) % 3;
                this.st.add((diff + 1) % 3, 1);
                this.st.add((diff + 2) % 3, -1);
                this.st.next();
            }
            this.last = guess;
        }

        void scan(int age, result res) {
            int storemove = res.move;
            res.move = this.st.max(age, res) ? (this.last + res.move) % 3 : storemove;
        }
    }

    class result {
        int move;
        int score;

        result() {
        }
    }

    class stat {
        int[][] sum;
        int age;

        stat() {
            this.sum = new int[1 + IocainePlayer.this.trials][3];
            this.age = 0;
            int i = 0;
            while (i < 3) {
                this.sum[this.age][i] = 0;
                ++i;
            }
        }

        void add(int i, int delta) {
            int[] nArray = this.sum[this.age];
            int n = i;
            nArray[n] = nArray[n] + delta;
        }

        void next() {
            if (this.age < IocainePlayer.this.trials) {
                ++this.age;
                int i = 0;
                while (i < 3) {
                    this.sum[this.age][i] = this.sum[this.age - 1][i];
                    ++i;
                }
            }
        }

        boolean max(int dage, result res) {
            res.move = -1;
            int i = 0;
            while (i < 3) {
                int diff = dage > this.age ? this.sum[this.age][i] : this.sum[this.age][i] - this.sum[this.age - dage][i];
                if (diff > res.score) {
                    res.score = diff;
                    res.move = i;
                }
                ++i;
            }
            return -1 != res.move;
        }
    }
}

