/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;
import java.util.TreeMap;

public class Muto5Player
implements RoshamboPlayer {
    int[] myHistory;
    int[] oppHistory;
    int lastMove;
    MyMethod[] methods;
    int trials;
    int score = 0;
    int lossStreak = 0;
    int lastMethod = 0;
    int currentMethod = 0;
    static final boolean verbose = false;
    static final int NUM_METHODS = 4;
    static final int LOSS_STREAK_MAX = 3;
    static final int LOSS_STREAK_PENALTY = 5;

    @Override
    public String getPlayerId() {
        return "MUTO";
    }

    @Override
    public String getAuthor() {
        return "Andrew Wheat/Tristan Allwood";
    }

    @Override
    public void reset() {
        this.reset(this.trials);
    }

    @Override
    public void reset(int aTrials) {
        this.trials = aTrials;
        this.myHistory = new int[aTrials + 1];
        this.oppHistory = new int[aTrials + 1];
        this.oppHistory[0] = 0;
        this.myHistory[0] = 0;
        this.methods = new MyMethod[4];
        this.methods[3] = new MyMethod(new NotInLast(aTrials), 1);
        this.methods[2] = new MyMethod(new Tris2(aTrials), 2);
        this.methods[1] = new MyMethod(new Tris3(aTrials), 3);
        this.methods[0] = new MyMethod(new MyRandom(aTrials), 4);
    }

    @Override
    public void storeMove(int move, int aScore) {
        this.oppHistory[0] = this.oppHistory[0] + 1;
        this.oppHistory[this.oppHistory[0]] = move;
        this.myHistory[0] = this.myHistory[0] + 1;
        this.myHistory[this.myHistory[0]] = this.lastMove;
        this.score += aScore;
        this.lossStreak = aScore < 0 ? ++this.lossStreak : 0;
        int i = 0;
        while (i < 4) {
            this.methods[i].thisMethod.storeMove(move, aScore);
            if (move == this.methods[i].myLastMove) {
                this.methods[i].myQueue.add(0);
            } else if (move == (this.methods[i].myLastMove + 1) % 3) {
                this.methods[i].myQueue.add(-1);
            } else {
                this.methods[i].myQueue.add(1);
            }
            this.methods[i].updateScore();
            ++i;
        }
    }

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public int nextMove() {
        int maxScore = this.methods[0].myScore;
        int maxIndex = 0;
        int secondIndex = 0;
        int i = 1;
        while (i < 4) {
            if (this.methods[i].myScore > maxScore) {
                secondIndex = maxIndex;
                maxIndex = i;
                maxScore = this.methods[i].myScore;
            } else if (this.methods[i].myScore == maxScore && this.methods[i].weighting > this.methods[maxIndex].weighting) {
                secondIndex = maxIndex;
                maxIndex = i;
            }
            this.methods[i].myLastMove = this.methods[i].thisMethod.nextMove();
            ++i;
        }
        this.currentMethod = maxIndex;
        if (this.lastMethod != this.currentMethod) {
            this.swap();
        }
        if (this.lossStreak >= 3) {
            this.lastMethod = this.currentMethod;
            this.currentMethod = secondIndex;
            this.methods[maxIndex].myScore = this.methods[secondIndex].myScore - 5;
            this.lastMove = this.methods[secondIndex].myLastMove;
            this.swap();
        } else {
            this.lastMove = this.methods[this.currentMethod].myLastMove;
        }
        this.lastMethod = this.currentMethod;
        return this.lastMove;
    }

    private void swap() {
        this.lossStreak = 0;
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }

    class MyMethod {
        RoshamboPlayer thisMethod;
        Queue myQueue;
        int myScore;
        int myLastMove;
        int weighting;
        String name;

        public MyMethod(RoshamboPlayer p, int weight) {
            this.myQueue = new Queue(10);
            this.myScore = this.myQueue.getSum();
            this.myLastMove = 0;
            this.thisMethod = p;
            this.weighting = weight;
            this.name = this.thisMethod.getPlayerId();
        }

        void updateScore() {
            this.myScore = this.myQueue.getSum();
        }
    }

    class MyRandom
    implements RoshamboPlayer {
        public MyRandom(int aTrials) {
            this.reset(aTrials);
        }

        @Override
        public int nextMove() {
            return Coin.flip();
        }

        @Override
        public void storeMove(int move, int aScore) {
        }

        @Override
        public void reset() {
            this.reset(0);
        }

        @Override
        public void reset(int aTrials) {
        }

        @Override
        public String getPlayerId() {
            return "MUTO [MyRandom]";
        }

        @Override
        public String getAuthor() {
            return "Andrew Wheat";
        }
    }

    class NotInLast
    implements RoshamboPlayer {
        private int myLastMove = Coin.flip();
        private int theirLastMove = Coin.flip();

        public NotInLast(int aTrials) {
            this.reset(aTrials);
        }

        @Override
        public void reset() {
            this.reset(0);
        }

        @Override
        public void reset(int aTrials) {
        }

        @Override
        public void storeMove(int move, int aScore) {
            this.theirLastMove = move;
        }

        @Override
        public int nextMove() {
            this.myLastMove = this.myLastMove == this.theirLastMove ? Coin.flip() : 3 - (this.myLastMove | this.theirLastMove);
            return this.myLastMove;
        }

        @Override
        public String getPlayerId() {
            return "MUTO [NotInLast]";
        }

        @Override
        public String getAuthor() {
            return "Tristran Allwood/Andrew Wheat";
        }
    }

    class Queue {
        TreeMap theData = new TreeMap();
        int first = 0;
        int last = 0;
        int sum = 0;
        int size = 0;

        Queue(int s) {
            this.size = s;
        }

        int getNext() {
            return 1;
        }

        void add(int a2) {
            this.theData.put(new Integer(this.last++), new Integer(a2));
            this.sum += a2;
            if (this.last - this.first > 10) {
                this.sum -= ((Integer)this.theData.get(new Integer(this.first))).intValue();
                this.theData.remove(new Integer(this.first));
                ++this.first;
            }
        }

        int getSum() {
            return this.sum;
        }
    }

    public class Tris2
    implements RoshamboPlayer {
        int[][][] matrix = new int[3][3][3];
        int hisLastMove = Coin.flip();
        int myLastMove = Coin.flip();
        int myLastMoveBar1 = Coin.flip();
        int[] pMoves;
        int cMax;
        int cSame;
        int cPos;

        public Tris2(int aTrials) {
            this.reset(aTrials);
        }

        @Override
        public void reset() {
            this.reset(0);
        }

        @Override
        public void reset(int aTrials) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    int k = 0;
                    while (k < 3) {
                        this.matrix[k][j][i] = 0;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public void storeMove(int move, int aScore) {
            int[] nArray = this.matrix[this.myLastMoveBar1][this.hisLastMove];
            int n = move;
            nArray[n] = nArray[n] + 1;
            this.hisLastMove = move;
            this.myLastMoveBar1 = this.myLastMove;
        }

        @Override
        public int nextMove() {
            this.pMoves = this.matrix[this.myLastMove][this.hisLastMove];
            this.cMax = this.pMoves[0];
            this.cPos = 0;
            this.cSame = 0;
            int i = 1;
            while (i < 3) {
                if (this.cMax < this.pMoves[i]) {
                    this.cMax = this.pMoves[i];
                    this.cPos = i;
                    this.cSame = 0;
                } else if (this.cMax == this.pMoves[i]) {
                    ++this.cSame;
                }
                ++i;
            }
            this.myLastMove = this.cSame == 1 ? (this.pMoves[0] == this.pMoves[1] ? Coin.flip(0.5, 0.5) : (this.pMoves[1] == this.pMoves[2] ? Coin.flip(0.0, 0.5) : Coin.flip(0.5, 0.0))) : (this.cSame == 2 ? Coin.flip() : this.cPos);
            ++this.myLastMove;
            this.myLastMove %= 3;
            return this.myLastMove;
        }

        @Override
        public String getPlayerId() {
            return "MUTO [Tris2]";
        }

        @Override
        public String getAuthor() {
            return "Tristan Allwood";
        }
    }

    public class Tris3
    implements RoshamboPlayer {
        static final int HISTORY_LENGTH = 10;
        int myLastMoveBar1;
        int hisLastMoveBar1;
        int myLastMove;
        int hisLastMove;
        int cTrial;
        HistoryState root;
        History hist;

        public Tris3(int t) {
            this.reset(t);
        }

        @Override
        public void reset() {
            this.reset(0);
        }

        @Override
        public void reset(int aTrials) {
            this.cTrial = 0;
            this.hist = new History();
        }

        @Override
        public int nextMove() {
            this.myLastMove = this.root == null ? Coin.flip() : this.root.getBestMove(this.hist.getCHistory());
            return this.myLastMove;
        }

        @Override
        public void storeMove(int move, int aScore) {
            this.hisLastMove = move;
            if (this.cTrial > 10) {
                if (this.root == null) {
                    this.root = new HistoryState(this.hist.getCHistory(), this.hisLastMove);
                } else {
                    this.root.addState(this.hist.getCHistory(), this.hisLastMove);
                }
            }
            this.hist.addPairToHistory(this.myLastMove, this.hisLastMove);
            ++this.cTrial;
        }

        @Override
        public String getPlayerId() {
            return "MUTO [Tris3]";
        }

        @Override
        public String getAuthor() {
            return "Tristan Allwood";
        }

        class History {
            int[][] cHistory = new int[10][2];
            int[][] tmpHistory;

            History() {
            }

            void addPairToHistory(int mLM, int hLM) {
                this.tmpHistory = new int[10][2];
                int i = 0;
                while (i < this.cHistory.length - 1) {
                    this.tmpHistory[i] = this.cHistory[i + 1];
                    ++i;
                }
                this.tmpHistory[this.tmpHistory.length - 1] = new int[]{mLM, hLM};
                this.cHistory = this.tmpHistory;
            }

            int[][] getCHistory() {
                return this.cHistory;
            }
        }

        class HistoryState {
            int[][] history;
            int future;
            int freq;
            HistoryState nextNode;

            public HistoryState(int[][] inHistory, int inFuture) {
                this.history = inHistory;
                this.future = inFuture;
                this.freq = 1;
            }

            void addState(int[][] inHistory, int inFuture) {
                HistoryState cHS = this;
                while (true) {
                    boolean matches = true;
                    int i = 0;
                    while (i < inHistory.length) {
                        if (inHistory[0] != cHS.history[0] || inHistory[1] != cHS.history[1]) {
                            matches = false;
                        }
                        ++i;
                    }
                    if (inFuture != cHS.future) {
                        matches = false;
                    }
                    if (matches) {
                        ++cHS.freq;
                        return;
                    }
                    if (cHS.nextNode == null) {
                        cHS.nextNode = new HistoryState(inHistory, inFuture);
                        return;
                    }
                    cHS = cHS.nextNode;
                }
            }

            int getBestMove(int[][] cHistory) {
                HistoryState cSH = this;
                long[] scores = new long[3];
                double[] dscores = new double[3];
                long[] divs = new long[3];
                while (cSH != null) {
                    long[] tmp = cSH.getScores(cHistory);
                    int n = (int)tmp[0];
                    scores[n] = scores[n] + tmp[1];
                    int n2 = (int)tmp[0];
                    divs[n2] = divs[n2] + tmp[2];
                    cSH = cSH.nextNode;
                }
                int i = 0;
                while (i < 3) {
                    dscores[i] = scores[i];
                    ++i;
                }
                double cMax = dscores[0];
                int cPos = 0;
                int cSame = 0;
                i = 1;
                while (i < 3) {
                    if (cMax < dscores[i]) {
                        cMax = dscores[i];
                        cPos = i;
                        cSame = 0;
                    } else if (cMax == dscores[i]) {
                        ++cSame;
                    }
                    ++i;
                }
                Tris3.this.myLastMove = cSame == 1 ? (dscores[0] == dscores[1] ? Coin.flip(0.5, 0.5) : (dscores[1] == dscores[2] ? Coin.flip(0.0, 0.5) : Coin.flip(0.5, 0.0))) : (cSame == 2 ? Coin.flip() : cPos);
                ++Tris3.this.myLastMove;
                Tris3.this.myLastMove %= 3;
                return Tris3.this.myLastMove;
            }

            long[] getScores(int[][] cHistory) {
                long[] output = new long[]{this.future, 0L, this.freq};
                int i = 0;
                while (i < cHistory.length) {
                    if (cHistory[i][0] == this.history[i][0] && cHistory[i][1] == this.history[i][1]) {
                        output[1] = output[1] + (long)((i + 1) * (i + 1));
                    }
                    ++i;
                }
                output[1] = output[1] * (long)(this.freq * this.freq);
                return output;
            }
        }
    }
}

