/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;
import com.anji.util.Configurable;
import com.anji.util.Properties;

public class OneTrackMindPlayer
implements RoshamboPlayer,
Configurable {
    private static final String ONE_TRACK_KEY = "onetrackmindplayer.onetrack";
    private static final String RAND_KEY = "onetrackmindplayer.start.random";
    private int oneTrack = 0;
    private boolean isRandStart = false;
    private static final double ONE_THIRD = 0.3333333333333333;

    public OneTrackMindPlayer() {
    }

    public OneTrackMindPlayer(int aTrack) {
        if (aTrack != 0 && aTrack != 2 && aTrack != 1) {
            throw new IllegalArgumentException("invalid R/S/P parameter " + aTrack);
        }
        this.oneTrack = aTrack;
    }

    public OneTrackMindPlayer(boolean aRandStart) {
        this.isRandStart = aRandStart;
    }

    @Override
    public void reset() {
        if (this.isRandStart) {
            this.oneTrack = Coin.flip(0.3333333333333333, 0.3333333333333333);
        }
    }

    @Override
    public void reset(int trials) {
        this.reset();
    }

    @Override
    public void storeMove(int move, int score) {
    }

    @Override
    public int nextMove() {
        return this.oneTrack;
    }

    @Override
    public String getPlayerId() {
        return String.valueOf(this.isRandStart ? "Rand" : OneTrackMindPlayer.toChoiceString(this.oneTrack)) + " 1 Track Player";
    }

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public String getAuthor() {
        return "Philip Tucker";
    }

    @Override
    public void init(Properties props) throws Exception {
        this.isRandStart = props.getBooleanProperty(RAND_KEY, false);
        String oneTrackVal = props.getProperty(ONE_TRACK_KEY, "rock").trim().toLowerCase();
        if (oneTrackVal.equals("rock")) {
            this.oneTrack = 0;
        } else if (oneTrackVal.equals("scissors")) {
            this.oneTrack = 2;
        } else if (oneTrackVal.equals("paper")) {
            this.oneTrack = 1;
        } else {
            throw new IllegalArgumentException("invalid rock/scissors/paper value: " + oneTrackVal);
        }
    }

    public int getOneTrack() {
        return this.oneTrack;
    }

    private static String toChoiceString(int choice) {
        return choice == 0 ? "Rock" : (choice == 2 ? "Scissors" : "Paper");
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }
}

