/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;
import com.anji.tournament.Game;
import com.anji.tournament.GameConfiguration;
import com.anji.tournament.GameResults;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.ScoringWeights;
import com.anji.util.Configurable;
import com.anji.util.Randomizer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class RoshamboGame
implements Game,
Configurable {
    private static final Logger logger = Logger.getLogger(RoshamboGame.class);
    private GameConfiguration gameConfig = GameConfiguration.DEFAULT;
    private RoshamboPlayer p;
    private RoshamboPlayer q;
    private String loaderror;
    private boolean loaded;
    private String name = "roshambo";

    public RoshamboGame() {
    }

    public RoshamboGame(GameConfiguration aConfig) {
        this.gameConfig = aConfig;
    }

    @Override
    public GameResults play(PlayerResults playerOneResults, PlayerResults playerTwoResults) {
        long startMillis = System.currentTimeMillis();
        GameResults gameResults = new GameResults();
        RoshamboPlayer p1 = (RoshamboPlayer)playerOneResults.getPlayer();
        RoshamboPlayer p2 = (RoshamboPlayer)playerTwoResults.getPlayer();
        int playerOneScore = this.play(p1, p2, 1);
        switch (playerOneScore) {
            case -1: {
                gameResults.incrementPlayer1Losses(1);
                break;
            }
            case 0: {
                gameResults.incrementTies(1);
                break;
            }
            case 1: {
                gameResults.incrementPlayer1Wins(1);
                break;
            }
            default: {
                throw new IllegalStateException("invalid result for single trial: " + playerOneScore);
            }
        }
        playerOneResults.getResults().increment(gameResults.getPlayer1Stats());
        playerTwoResults.getResults().increment(gameResults.getPlayer2Stats());
        if (this.gameConfig.doLogResults()) {
            logger.info(new StringBuffer(this.name).append(": ").append(p1).append(" vs ").append(p2).append(": ").append(playerOneScore).append(System.currentTimeMillis() - startMillis).append(" ms").toString());
        }
        return gameResults;
    }

    private int play(RoshamboPlayer contestant, RoshamboPlayer opponent, int trials) {
        int totscore = 0;
        if (this.gameConfig.doResetPlayers()) {
            contestant.reset(trials);
            opponent.reset(trials);
        }
        int i = 0;
        while (i < trials) {
            int pm = contestant.nextMove();
            int qm = opponent.nextMove();
            logger.debug(String.valueOf(contestant.toString()) + ": roshambo move=" + pm);
            logger.debug(String.valueOf(opponent.toString()) + ": roshambo move=" + qm);
            int score = 0;
            if (pm != qm) {
                score = pm == 1 && qm == 0 || pm == 0 && qm == 2 || pm == 2 && qm == 1 ? 1 : -1;
            }
            contestant.storeMove(qm, score);
            opponent.storeMove(pm, -score);
            totscore += score;
            ++i;
        }
        return totscore;
    }

    public static void main(String[] args) throws Exception {
        RoshamboGame m;
        Properties p = new Properties();
        p.load(ClassLoader.getSystemResourceAsStream("roshambo.properties"));
        PropertyConfigurator.configure(p);
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 2) {
            System.err.println("usage: <cmd> <roshambo-player1-class> <roshambo-player2-class> <trials>");
        }
        if (!(m = new RoshamboGame(args[0], args[1])).isLoaded()) {
            System.out.println(m.getError());
            return;
        }
        System.out.println(m.describe());
        int score = m.match(Integer.parseInt(args[2]));
        System.out.println("Score: " + score);
    }

    public RoshamboGame(String player1, String player2) {
        this.loaded = false;
        this.loaderror = "";
        this.p = this.loadPlayer(player1);
        if (this.p == null) {
            return;
        }
        this.q = this.loadPlayer(player2);
        if (this.q == null) {
            return;
        }
        this.loaded = true;
        this.loaderror = "";
    }

    public String describe() {
        if (!this.loaded) {
            return "Players not loaded.";
        }
        return String.valueOf(this.p.getPlayerId()) + " (" + this.p.getAuthor() + ") vs. " + this.q.getPlayerId() + " (" + this.q.getAuthor() + ")";
    }

    public int match(int trials) {
        if (!this.loaded) {
            return -1;
        }
        return this.play(this.p, this.q, trials);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getError() {
        return this.loaderror;
    }

    private RoshamboPlayer loadPlayer(String playerName) {
        RoshamboPlayer player;
        this.loaderror = "";
        try {
            player = (RoshamboPlayer)Class.forName(playerName).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.loaderror = "Cannot find class " + playerName;
            return null;
        }
        catch (Exception e) {
            this.loaderror = "Error loading class " + playerName + " (" + e + ")";
            return null;
        }
        return player;
    }

    @Override
    public Class requiredPlayerClass() {
        return RoshamboPlayer.class;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int getMaxScore(ScoringWeights aWeights) {
        return aWeights.getWinValue();
    }

    @Override
    public int getMinScore(ScoringWeights aWeights) {
        return aWeights.getLossValue();
    }

    @Override
    public void init(com.anji.util.Properties props) throws Exception {
        this.gameConfig = (GameConfiguration)props.singletonObjectProperty(GameConfiguration.class);
        this.name = String.valueOf(this.name) + " " + props.getName();
        Randomizer randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        Coin.setRand(randomizer.getRand());
    }
}

