/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.integration.AnjiNetTranscriber;
import com.anji.integration.TranscriberException;
import com.anji.nn.AnjiNet;
import com.anji.roshambo.AnjiNetRoshamboPlayer;
import com.anji.roshambo.AnjiNetScanningRoshamboPlayer;
import com.anji.roshambo.RoshamboPlayer;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerTranscriber;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.Random;
import org.jgap.Chromosome;

public class RoshamboPlayerTranscriber
implements PlayerTranscriber,
Configurable {
    public static final String DETERMINISTIC_KEY = "roshambo.anji.deterministic";
    public static final String HISTORY_SIZE_KEY = "roshambo.anji.history.size";
    public static final String SCANNING_WINDOW_SIZE_KEY = "roshambo.anji.scanning.window.size";
    private int historySize = 1;
    private AnjiNetTranscriber anjiNetTranscriber;
    private int recurrentCycles = 1;
    private boolean isDeterministic = false;
    private Randomizer randomizer;
    private int scanningWindowSize = 0;

    public RoshamboPlayer newRoshamboPlayer(Chromosome genotype) throws TranscriberException {
        AnjiNet net = this.anjiNetTranscriber.newAnjiNet(genotype);
        try {
            Random rand = this.isDeterministic ? null : this.randomizer.getRand();
            RoshamboPlayer result2 = this.scanningWindowSize > 0 ? new AnjiNetScanningRoshamboPlayer(net, rand, this.recurrentCycles, this.historySize, this.scanningWindowSize) : new AnjiNetRoshamboPlayer(net, rand, this.recurrentCycles, this.historySize);
            return result2;
        }
        catch (IllegalArgumentException e) {
            throw new TranscriberException("error transcribing " + genotype.getId(), e);
        }
    }

    @Override
    public Player newPlayer(Chromosome genotype) throws TranscriberException {
        return this.newRoshamboPlayer(genotype);
    }

    @Override
    public Object transcribe(Chromosome genotype) throws TranscriberException {
        return this.newRoshamboPlayer(genotype);
    }

    @Override
    public Class getPhenotypeClass() {
        return RoshamboPlayer.class;
    }

    @Override
    public void init(Properties aProps) throws Exception {
        this.anjiNetTranscriber = (AnjiNetTranscriber)aProps.singletonObjectProperty(AnjiNetTranscriber.class);
        this.isDeterministic = aProps.getBooleanProperty(DETERMINISTIC_KEY, false);
        this.randomizer = (Randomizer)aProps.singletonObjectProperty(Randomizer.class);
        this.recurrentCycles = aProps.getIntProperty("recurrent.cycles", 1);
        this.historySize = aProps.getIntProperty(HISTORY_SIZE_KEY, 1);
        this.scanningWindowSize = aProps.getIntProperty(SCANNING_WINDOW_SIZE_KEY, 0);
        if (this.scanningWindowSize > this.historySize) {
            throw new IllegalArgumentException("scanningWindowSize " + this.scanningWindowSize + " > history size " + this.historySize);
        }
    }
}

