/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;

public class Tris3Player
implements RoshamboPlayer {
    private static final int HISTORY_LENGTH = 10;
    private int myLastMoveBar1;
    private int hisLastMoveBar1;
    int myLastMove;
    private int hisLastMove;
    private int cTrial;
    private HistoryState root;
    private History hist;

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int trials) {
        this.cTrial = 0;
        this.hisLastMove = 0;
        this.hisLastMoveBar1 = 0;
        this.hist = new History();
        this.myLastMove = 0;
        this.myLastMoveBar1 = 0;
        this.root = null;
    }

    @Override
    public int nextMove() {
        this.myLastMove = this.root == null ? Coin.flip() : this.root.getBestMove(this.hist.getCHistory());
        return this.myLastMove;
    }

    @Override
    public void storeMove(int move, int score) {
        this.hisLastMove = move;
        if (this.cTrial > 10) {
            if (this.root == null) {
                this.root = new HistoryState(this.hist.getCHistory(), this.hisLastMove);
            } else {
                this.root.addState(this.hist.getCHistory(), this.hisLastMove);
            }
        }
        this.hist.addPairToHistory(this.myLastMove, this.hisLastMove);
        ++this.cTrial;
    }

    @Override
    public String getPlayerId() {
        return "Tris3 - the super history bot";
    }

    @Override
    public String getAuthor() {
        return "Tristan Allwood";
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }

    class History {
        int[][] cHistory = new int[10][2];
        int[][] tmpHistory;

        History() {
        }

        void addPairToHistory(int mLM, int hLM) {
            this.tmpHistory = new int[10][2];
            int i = 0;
            while (i < this.cHistory.length - 1) {
                this.tmpHistory[i] = this.cHistory[i + 1];
                ++i;
            }
            this.tmpHistory[this.tmpHistory.length - 1] = new int[]{mLM, hLM};
            this.cHistory = this.tmpHistory;
        }

        int[][] getCHistory() {
            return this.cHistory;
        }
    }

    class HistoryState {
        int[][] history;
        int future;
        int freq;
        HistoryState nextNode;

        public HistoryState(int[][] inHistory, int inFuture) {
            this.history = inHistory;
            this.future = inFuture;
            this.freq = 1;
        }

        void addState(int[][] inHistory, int inFuture) {
            HistoryState cHS = this;
            while (true) {
                boolean matches = true;
                int i = 0;
                while (i < inHistory.length) {
                    if (inHistory[0] != cHS.history[0] || inHistory[1] != cHS.history[1]) {
                        matches = false;
                    }
                    ++i;
                }
                if (inFuture != cHS.future) {
                    matches = false;
                }
                if (matches) {
                    ++cHS.freq;
                    return;
                }
                if (cHS.nextNode == null) {
                    cHS.nextNode = new HistoryState(inHistory, inFuture);
                    return;
                }
                cHS = cHS.nextNode;
            }
        }

        int getBestMove(int[][] cHistory) {
            HistoryState cSH = this;
            long[] scores = new long[3];
            double[] dscores = new double[3];
            long[] divs = new long[3];
            while (cSH != null) {
                long[] tmp = cSH.getScores(cHistory);
                int n = (int)tmp[0];
                scores[n] = scores[n] + tmp[1];
                int n2 = (int)tmp[0];
                divs[n2] = divs[n2] + tmp[2];
                cSH = cSH.nextNode;
            }
            int i = 0;
            while (i < 3) {
                dscores[i] = scores[i];
                ++i;
            }
            double cMax = dscores[0];
            int cPos = 0;
            int cSame = 0;
            i = 1;
            while (i < 3) {
                if (cMax < dscores[i]) {
                    cMax = dscores[i];
                    cPos = i;
                    cSame = 0;
                } else if (cMax == dscores[i]) {
                    ++cSame;
                }
                ++i;
            }
            Tris3Player.this.myLastMove = cSame == 1 ? (dscores[0] == dscores[1] ? Coin.flip(0.5, 0.5) : (dscores[1] == dscores[2] ? Coin.flip(0.0, 0.5) : Coin.flip(0.5, 0.0))) : (cSame == 2 ? Coin.flip() : cPos);
            ++Tris3Player.this.myLastMove;
            Tris3Player.this.myLastMove %= 3;
            return Tris3Player.this.myLastMove;
        }

        long[] getScores(int[][] cHistory) {
            long[] output = new long[]{this.future, 0L, this.freq};
            int i = 0;
            while (i < cHistory.length) {
                if (cHistory[i][0] == this.history[i][0] && cHistory[i][1] == this.history[i][1]) {
                    output[1] = output[1] + (long)((i + 1) * (i + 1));
                }
                ++i;
            }
            output[1] = output[1] * (long)(this.freq * this.freq);
            return output;
        }
    }
}

