/*
 * Decompiled with CFR 0.152.
 */
package com.anji.roshambo;

import com.anji.roshambo.Coin;
import com.anji.roshambo.RoshamboPlayer;
import java.util.LinkedList;

public class WizardexpPlayer
implements RoshamboPlayer {
    private static final int[] LENGTHS = new int[]{1, 5, 10, 25, 50, 100, 250, 500};
    int myMove_;
    HistoryPredictor oppPredictor_;
    HistoryPredictor selfPredictor_;
    int[] idealSequence_ = new int[0];
    int[] worstSequence_;
    int n_;
    int[][] predictorHistory_;
    int[] selectorChoice_;
    int[] selectorScore_;

    @Override
    public void reset() {
        this.reset(this.idealSequence_.length);
    }

    @Override
    public void reset(int trials) {
        this.myMove_ = 0;
        this.selfPredictor_ = new HistoryPredictor(trials);
        this.oppPredictor_ = new HistoryPredictor(trials);
        this.idealSequence_ = new int[trials];
        this.worstSequence_ = new int[trials];
        this.n_ = 0;
        this.predictorHistory_ = new int[7][trials];
        this.selectorChoice_ = new int[LENGTHS.length];
        this.selectorScore_ = new int[LENGTHS.length];
    }

    public String toString() {
        return this.getPlayerId();
    }

    @Override
    public void storeMove(int move, int score) {
        this.oppPredictor_.storeMove(this.myMove_, move);
        this.selfPredictor_.storeMove(move, this.myMove_);
        this.idealSequence_[this.n_] = this.beat(move);
        this.worstSequence_[this.n_] = this.lose(move);
        int i = 0;
        while (i < LENGTHS.length) {
            int play = this.predictorHistory_[this.selectorChoice_[i]][this.n_];
            if (play == this.beat(move)) {
                int n = i;
                this.selectorScore_[n] = this.selectorScore_[n] + 1;
            } else if (play == this.lose(move)) {
                int n = i;
                this.selectorScore_[n] = this.selectorScore_[n] - 1;
            }
            ++i;
        }
        ++this.n_;
    }

    @Override
    public int nextMove() {
        int move;
        int myMove = this.selfPredictor_.nextMove();
        int opMove = this.oppPredictor_.nextMove();
        this.predictorHistory_[0][this.n_] = myMove;
        this.predictorHistory_[1][this.n_] = this.beat(myMove);
        this.predictorHistory_[2][this.n_] = this.beat(this.beat(myMove));
        this.predictorHistory_[3][this.n_] = opMove;
        this.predictorHistory_[4][this.n_] = this.beat(opMove);
        this.predictorHistory_[5][this.n_] = this.beat(this.beat(opMove));
        this.predictorHistory_[6][this.n_] = Coin.flip();
        int i = 0;
        while (i < LENGTHS.length) {
            this.selectorChoice_[i] = this.selectPredictor(LENGTHS[i]);
            ++i;
        }
        int bestSelector = this.maxIndex(this.selectorScore_);
        this.myMove_ = move = this.predictorHistory_[this.selectorChoice_[bestSelector]][this.n_];
        return move;
    }

    @Override
    public String getPlayerId() {
        return "WizardExp";
    }

    @Override
    public String getAuthor() {
        return "Ian Glover";
    }

    private int beat(int play) {
        return (play + 1) % 3;
    }

    private int lose(int play) {
        return (play + 2) % 3;
    }

    private int selectPredictor(int length) {
        int best = 0;
        int bestScore = -10000;
        int i = 0;
        while (i < this.predictorHistory_.length) {
            int score = 0;
            int m = this.n_ - 1;
            while (m > this.n_ - length && m >= 0) {
                if (this.predictorHistory_[i][m] == this.idealSequence_[m]) {
                    ++score;
                }
                if (this.predictorHistory_[i][m] == this.worstSequence_[m]) {
                    --score;
                }
                --m;
            }
            if (score > bestScore) {
                bestScore = score;
                best = i;
            }
            ++i;
        }
        return best;
    }

    protected int maxIndex(int[] array) {
        LinkedList<Integer> candidates = new LinkedList<Integer>();
        int max = array[0];
        int i = 0;
        while (i < array.length) {
            if (array[i] == max) {
                candidates.add(new Integer(i));
            } else if (array[i] > max) {
                candidates.clear();
                candidates.add(new Integer(i));
                max = array[i];
            }
            ++i;
        }
        int len = candidates.size();
        int i2 = 0;
        i2 = 0;
        while (i2 < len - 1) {
            double p = 1.0 / (double)(len - i2);
            if (Coin.flip(p) == 0) break;
            ++i2;
        }
        int index = (Integer)candidates.get(i2);
        return index;
    }

    public int hashCode() {
        return this.getPlayerId().hashCode();
    }

    private class HistoryPredictor {
        static final int MAX_DEPTH = 80;
        Node root_;
        int[] myHist_;
        int[] opHist_;

        public HistoryPredictor(int trials) {
            this.root_ = new Node();
            this.myHist_ = new int[trials];
            this.opHist_ = new int[trials];
        }

        public int nextMove() {
            Node node = this.find(this.root_, this.root_, WizardexpPlayer.this.n_ - 1);
            return WizardexpPlayer.this.maxIndex(node.count_);
        }

        public void storeMove(int myMove, int opMove) {
            this.myHist_[WizardexpPlayer.this.n_] = myMove;
            this.opHist_[WizardexpPlayer.this.n_] = opMove;
            this.add(this.root_, WizardexpPlayer.this.n_, WizardexpPlayer.this.n_);
        }

        private void add(Node node, int current, int end) {
            if (current < 1) {
                return;
            }
            int n = this.opHist_[end];
            node.count_[n] = node.count_[n] + 1;
            if (end - current > 80) {
                return;
            }
            int next = current - 1;
            if (node.children_[this.myHist_[next]][this.opHist_[next]] == null) {
                node.children_[this.myHist_[next]][this.opHist_[next]] = new Node();
            }
            this.add(node.children_[this.myHist_[next]][this.opHist_[next]], next, end);
        }

        private Node find(Node node, Node best, int current) {
            int total = 0;
            int i = 0;
            while (i < 3) {
                total += node.count_[i];
                ++i;
            }
            if (total == 0) {
                return best;
            }
            if (node.children_[this.myHist_[current]][this.opHist_[current]] == null) {
                return node;
            }
            return this.find(node.children_[this.myHist_[current]][this.opHist_[current]], node, current - 1);
        }
    }

    private class Node {
        public Node[][] children_;
        public int[] count_ = new int[3];

        Node() {
            this.children_ = new Node[3][3];
        }
    }
}

