/*
 * Decompiled with CFR 0.152.
 */
package com.anji.run;

import com.anji.integration.Generation;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.jgap.Genotype;
import org.jgap.event.GeneticEvent;
import org.jgap.event.GeneticEventListener;

public class Run
implements GeneticEventListener,
Configurable {
    private static final String RUN_KEY = "run.name";
    private int currentGenerationNumber = 1;
    private Long id;
    private String name;
    private List generations = new ArrayList();
    private Properties props;
    private Calendar startTime = Calendar.getInstance();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        Run other = (Run)o;
        return this.id.equals(other.id);
    }

    public Run() {
    }

    public Run(String aName) {
        this.name = aName;
    }

    public void addGeneration(Genotype genotype) {
        this.generations.add(new Generation(genotype, this.currentGenerationNumber++));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void geneticEventFired(GeneticEvent event) {
        Genotype genotype = (Genotype)event.getSource();
        if ("genotype_evaluated_event".equals(event.getEventName())) {
            this.addGeneration(genotype);
        }
    }

    public String getName() {
        return this.name;
    }

    public List getGenerations() {
        return this.generations;
    }

    private void setGenerations(List aGenerations) {
        this.generations = aGenerations;
    }

    private void setName(String aName) {
        this.name = aName;
    }

    private Long getId() {
        return this.id;
    }

    private void setId(Long aId) {
        this.id = aId;
    }

    @Override
    public void init(Properties aProps) throws Exception {
        this.props = aProps;
        this.name = this.props.getProperty(RUN_KEY);
    }

    public Properties getProps() {
        return this.props;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }
}

