/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Game;
import com.anji.tournament.GameResults;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.PlayerResultsScoreComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class Bracket {
    private static final Logger logger = Logger.getLogger(Bracket.class);
    private Random rand;
    private List contestants = new ArrayList();
    private Game game;
    private String name;

    public Bracket(String aName, Random aRand, List aContestants, Game aGame) {
        this.name = aName;
        this.rand = aRand;
        if (aContestants != null) {
            this.contestants.addAll(aContestants);
        }
        this.game = aGame;
    }

    public int size() {
        return this.contestants.size();
    }

    public List getContestants() {
        return Collections.unmodifiableList(this.contestants);
    }

    public void clearContestants() {
        this.contestants.clear();
    }

    public void addContestants(List newContestants) {
        this.contestants.addAll(0, newContestants);
    }

    public List playBracket() {
        int startingSize = this.contestants.size();
        Collections.shuffle(this.contestants, this.rand);
        Collections.sort(this.contestants, PlayerResultsScoreComparator.getAscendingInstance());
        ArrayList<PlayerResults> losers = new ArrayList<PlayerResults>();
        Iterator it = this.contestants.iterator();
        while (it.hasNext()) {
            PlayerResults player1Results = (PlayerResults)it.next();
            if (it.hasNext()) {
                PlayerResults player2Results = (PlayerResults)it.next();
                GameResults results = this.game.play(player1Results, player2Results);
                if (results.getPlayer1Stats().isWin(this.rand)) {
                    losers.add(player2Results);
                    continue;
                }
                losers.add(player1Results);
                continue;
            }
            logger.warn("odd number of players in winners bracket, one player gets bye: " + player1Results.getPlayer().getPlayerId());
        }
        this.contestants.removeAll(losers);
        Collections.sort(losers, PlayerResultsScoreComparator.getDescendingInstance());
        int endingSize = this.contestants.size();
        logger.info(String.valueOf(this.name) + " bracket: " + startingSize + "->" + endingSize);
        return losers;
    }

    public String toString() {
        return this.contestants.toString();
    }
}

