/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Player;
import com.anji.tournament.PlayerResultsScoreComparator;
import com.anji.tournament.Tournament;
import com.anji.tournament.TournamentPlayerResults;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CompositeTournament
implements Tournament,
Configurable {
    private static final String SUB_TOURNAMENTS_KEY = "composite.subtournaments";
    private List subTourneys = new ArrayList();
    private int minScore = 0;
    private int maxScore = 0;

    public CompositeTournament() {
    }

    public CompositeTournament(List aSubTourneys) {
        this();
        this.init(aSubTourneys);
    }

    @Override
    public void clearContestants() {
        for (Tournament t : this.subTourneys) {
            t.clearContestants();
        }
    }

    @Override
    public void addContestant(Player aContestant) {
        for (Tournament t : this.subTourneys) {
            t.addContestant(aContestant);
        }
    }

    @Override
    public List playTournament() {
        List results;
        Tournament t;
        HashMap<String, TournamentPlayerResults> playerResults = new HashMap<String, TournamentPlayerResults>();
        Iterator tourneyIter = this.subTourneys.iterator();
        if (tourneyIter.hasNext()) {
            t = (Tournament)tourneyIter.next();
            results = t.playTournament();
            for (TournamentPlayerResults firstResults : results) {
                playerResults.put(firstResults.getPlayer().getPlayerId(), firstResults);
            }
        }
        while (tourneyIter.hasNext()) {
            t = (Tournament)tourneyIter.next();
            results = t.playTournament();
            for (TournamentPlayerResults newResults : results) {
                TournamentPlayerResults previousResults = (TournamentPlayerResults)playerResults.get(newResults.getPlayer().getPlayerId());
                previousResults.getResults().increment(newResults.getResults());
            }
        }
        ArrayList tournamentResults = new ArrayList(playerResults.values());
        Collections.sort(tournamentResults, PlayerResultsScoreComparator.getDescendingTournamentInstance());
        return tournamentResults;
    }

    @Override
    public int getMaxScore() {
        return this.maxScore;
    }

    @Override
    public int getMinScore() {
        return this.minScore;
    }

    @Override
    public void init(Properties props) throws Exception {
        this.init(props.newObjectListProperty(SUB_TOURNAMENTS_KEY));
    }

    private void init(List aSubTourneys) {
        this.subTourneys = aSubTourneys;
        this.minScore = 0;
        this.maxScore = 0;
        for (Tournament t : this.subTourneys) {
            this.minScore += t.getMinScore();
            this.maxScore += t.getMaxScore();
        }
    }

    public List getSubTournaments() {
        return this.subTourneys;
    }
}

