/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Game;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.ScoringWeights;
import com.anji.tournament.SimpleTournament;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class DirectTournament
extends SimpleTournament
implements Configurable {
    private Logger logger = Logger.getLogger(DirectTournament.class);
    private static final String OPPONENTS_KEY = "direct.opponents";
    private List opponentsResults = new ArrayList();
    private SimpleTournament.PlayerPair currentPlayerPair;
    private Iterator playerIter;
    private Iterator opponentResultsIter;
    private Random rand;

    public DirectTournament(Game aGame, ScoringWeights aWeights, Random aRand) {
        super(aGame, aWeights);
        this.rand = aRand;
    }

    public DirectTournament() {
    }

    @Override
    public void init(Properties props) throws Exception {
        super.init(props);
        Randomizer randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        this.rand = randomizer.getRand();
        this.addOpponents(props.newObjectListProperty(OPPONENTS_KEY));
    }

    public void addOpponents(Collection opponents) {
        Iterator it = opponents.iterator();
        while (it.hasNext()) {
            this.addOpponent((Player)it.next());
        }
    }

    public void addOpponent(Player opponent) {
        this.opponentsResults.add(new PlayerResults(opponent, this.getScoringWeights()));
    }

    @Override
    protected boolean hasNextPlayerPair() {
        return this.currentPlayerPair != null && (this.playerIter.hasNext() || this.opponentResultsIter.hasNext());
    }

    @Override
    protected SimpleTournament.PlayerPair nextPlayerPair() {
        if (this.currentPlayerPair != null) {
            if (!this.opponentResultsIter.hasNext()) {
                if (this.playerIter.hasNext()) {
                    this.currentPlayerPair.contestant = (PlayerResults)this.playerIter.next();
                    this.currentPlayerPair.opponent = null;
                    Collections.shuffle(this.opponentsResults, this.rand);
                    this.opponentResultsIter = this.opponentsResults.iterator();
                } else {
                    this.currentPlayerPair = null;
                }
            }
            if (this.currentPlayerPair != null) {
                this.currentPlayerPair.opponent = (PlayerResults)this.opponentResultsIter.next();
            }
        }
        return this.currentPlayerPair;
    }

    @Override
    protected void startTournament() {
        this.playerIter = this.getResults().iterator();
        Collections.shuffle(this.opponentsResults, this.rand);
        this.opponentResultsIter = this.opponentsResults.iterator();
        this.currentPlayerPair = new SimpleTournament.PlayerPair();
        if (this.playerIter.hasNext()) {
            this.currentPlayerPair.contestant = (PlayerResults)this.playerIter.next();
        }
    }

    @Override
    public int getMaxScore() {
        return this.opponentsResults.size() * this.getGame().getMaxScore(this.getScoringWeights());
    }

    public List getOpponentsAndResults() {
        return this.opponentsResults;
    }

    @Override
    public int getMinScore() {
        return this.opponentsResults.size() * this.getGame().getMinScore(this.getScoringWeights());
    }

    @Override
    protected void endTournament() {
        Iterator it = this.opponentsResults.iterator();
        int idx = 0;
        while (it.hasNext()) {
            PlayerResults results = (PlayerResults)it.next();
            this.logger.info("opponent " + ++idx + ": " + results.toString());
        }
    }
}

