/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Bracket;
import com.anji.tournament.Game;
import com.anji.tournament.GameResults;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.PlayerResultsScoreComparator;
import com.anji.tournament.ScoringWeights;
import com.anji.tournament.Tournament;
import com.anji.tournament.TournamentPlayerResults;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class DoubleEliminationTournament
implements Tournament,
Configurable {
    private List contestants = new ArrayList();
    private ScoringWeights scoringWeights;
    private Random rand;
    private Game game;

    public DoubleEliminationTournament() {
    }

    public DoubleEliminationTournament(Game aGame, ScoringWeights aWeights, Random aRand) {
        this.init(aGame, aWeights, aRand);
    }

    private void init(Game aGame, ScoringWeights aWeights, Random aRand) {
        if (aWeights.getLossValue() > 0) {
            throw new IllegalArgumentException("can not have positive loss value for tournaments with variable numbers of games");
        }
        this.game = aGame;
        this.scoringWeights = aWeights;
        this.rand = aRand;
    }

    @Override
    public void clearContestants() {
        this.contestants.clear();
    }

    @Override
    public void addContestant(Player aContestant) {
        this.contestants.add(new PlayerResults(aContestant, this.scoringWeights));
    }

    @Override
    public List playTournament() {
        Bracket winnersBracket = new Bracket("winners", this.rand, this.contestants, this.game);
        Bracket losersBracket = new Bracket("losers", this.rand, null, this.game);
        ArrayList<TournamentPlayerResults> tourneyResults = new ArrayList<TournamentPlayerResults>();
        int roundScore = 0;
        int rank = this.contestants.size();
        while (winnersBracket.size() + losersBracket.size() > 1) {
            List losers;
            if (winnersBracket.size() == 1 && losersBracket.size() == 1) {
                this.playChampionshipRound(winnersBracket, losersBracket, rank, roundScore, tourneyResults);
                continue;
            }
            if (losersBracket.size() > 1) {
                losers = losersBracket.playBracket();
                Collections.sort(losers, PlayerResultsScoreComparator.getAscendingInstance());
                int tieBreakerBonus = 0;
                for (PlayerResults pr : losers) {
                    tourneyResults.add(0, new TournamentPlayerResults(pr, rank--, roundScore + tieBreakerBonus++));
                }
                int n = roundScore = roundScore == 0 ? this.contestants.size() : roundScore * 2;
            }
            if (winnersBracket.size() <= 1) continue;
            losers = winnersBracket.playBracket();
            losersBracket.addContestants(losers);
        }
        return tourneyResults;
    }

    private void playChampionshipRound(Bracket winnersBracket, Bracket losersBracket, int rank, int roundScore, List tourneyResults) {
        PlayerResults player2Results;
        PlayerResults player1Results = (PlayerResults)winnersBracket.getContestants().get(0);
        GameResults results = this.game.play(player1Results, player2Results = (PlayerResults)losersBracket.getContestants().get(0));
        if (results.getPlayer1Stats().isWin(this.rand)) {
            TournamentPlayerResults runnerUp = new TournamentPlayerResults(player2Results, rank--, roundScore);
            TournamentPlayerResults champ = new TournamentPlayerResults(player1Results, rank--, roundScore * 2);
            tourneyResults.add(0, runnerUp);
            tourneyResults.add(0, champ);
        } else {
            results = this.game.play(player1Results, player2Results);
            if (results.getPlayer1Stats().isWin(this.rand)) {
                TournamentPlayerResults runnerUp = new TournamentPlayerResults(player2Results, rank--, roundScore);
                TournamentPlayerResults champ = new TournamentPlayerResults(player1Results, rank--, roundScore * 2);
                tourneyResults.add(0, runnerUp);
                tourneyResults.add(0, champ);
            } else {
                TournamentPlayerResults runnerUp = new TournamentPlayerResults(player1Results, rank--, roundScore);
                TournamentPlayerResults champ = new TournamentPlayerResults(player2Results, rank--, roundScore * 2);
                tourneyResults.add(0, runnerUp);
                tourneyResults.add(0, champ);
            }
        }
        winnersBracket.clearContestants();
        losersBracket.clearContestants();
    }

    public int getMaxRounds() {
        int result2 = 0;
        int wbCount = this.contestants.size();
        int lbCount = 0;
        while (wbCount + lbCount > 1) {
            if (wbCount == 1 && lbCount == 1) {
                lbCount = 0;
            } else {
                int loserCount;
                if (lbCount > 1) {
                    loserCount = lbCount / 2;
                    lbCount -= loserCount;
                }
                if (wbCount > 1) {
                    loserCount = wbCount / 2;
                    wbCount -= loserCount;
                    lbCount += loserCount;
                }
            }
            ++result2;
        }
        return result2;
    }

    public int getMaxEliminationRounds() {
        int result2 = 0;
        int wbCount = this.contestants.size();
        int lbCount = 0;
        while (wbCount + lbCount > 1) {
            int loserCount;
            if (wbCount == 1 && lbCount == 1) {
                lbCount = 0;
                ++result2;
                continue;
            }
            if (lbCount > 1) {
                loserCount = lbCount / 2;
                lbCount -= loserCount;
                ++result2;
            }
            if (wbCount <= 1) continue;
            loserCount = wbCount / 2;
            wbCount -= loserCount;
            lbCount += loserCount;
        }
        return result2;
    }

    @Override
    public int getMaxScore() {
        int size = this.contestants.size();
        if (size < 2) {
            return 0;
        }
        return (int)Math.pow(2.0, this.getMaxEliminationRounds() - 1) * size;
    }

    @Override
    public int getMinScore() {
        return 0;
    }

    @Override
    public void init(Properties props) throws Exception {
        Randomizer randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        String componentName = props.getProperty("component");
        Game aGame = (Game)props.newObjectProperty(componentName);
        this.init(aGame, (ScoringWeights)props.singletonObjectProperty(ScoringWeights.class), randomizer.getRand());
    }
}

