/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Game;
import com.anji.tournament.GameConfiguration;
import com.anji.tournament.GameResults;
import com.anji.tournament.IteratedPlayer;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.ScoringWeights;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import org.apache.log4j.Logger;

public class IteratedGame
implements Game,
Configurable {
    private static final Logger logger = Logger.getLogger(IteratedGame.class);
    private static final String COMPONENT_COUNT_KEY = "component.count";
    private static final String COMPONENT_KEY = "component";
    private GameConfiguration config = GameConfiguration.DEFAULT;
    private Game componentGame;
    private int iterationCount = 0;
    private String name = "iterated-game";

    public IteratedGame() {
    }

    public IteratedGame(Game aComponentGame, int anIterationCount) {
        this(aComponentGame, anIterationCount, GameConfiguration.DEFAULT);
    }

    public IteratedGame(Game aComponentGame, int anIterationCount, GameConfiguration aConfig) {
        this.componentGame = aComponentGame;
        this.iterationCount = anIterationCount;
        this.config = aConfig;
    }

    private void reset(Player p) {
        if (p instanceof IteratedPlayer) {
            IteratedPlayer ip = (IteratedPlayer)p;
            ip.reset(this.iterationCount);
        } else {
            p.reset();
        }
    }

    @Override
    public GameResults play(PlayerResults contestantResults, PlayerResults opponentResults) {
        long startMillis = System.currentTimeMillis();
        if (this.config.doResetPlayers()) {
            this.reset(contestantResults.getPlayer());
            this.reset(opponentResults.getPlayer());
        }
        GameResults results = new GameResults();
        int i = 0;
        while (i < this.iterationCount) {
            GameResults iterationResults;
            if (i % 2 == 0) {
                iterationResults = this.componentGame.play(contestantResults, opponentResults);
                results.increment(iterationResults);
            } else {
                iterationResults = this.componentGame.play(opponentResults, contestantResults);
                results.incrementSwapped(iterationResults);
            }
            ++i;
        }
        if (this.config.doLogResults()) {
            logger.info(new StringBuffer(this.name).append(" ").append(contestantResults.getPlayer()).append(" vs ").append(opponentResults.getPlayer()).append(": ").append(results).append(": ").append(System.currentTimeMillis() - startMillis).append(" ms").toString());
        }
        return results;
    }

    @Override
    public Class requiredPlayerClass() {
        return this.componentGame.requiredPlayerClass();
    }

    @Override
    public int getMaxScore(ScoringWeights aWeights) {
        return this.iterationCount * this.componentGame.getMaxScore(aWeights);
    }

    @Override
    public int getMinScore(ScoringWeights aWeights) {
        return this.iterationCount * this.componentGame.getMinScore(aWeights);
    }

    @Override
    public void init(Properties props) throws Exception {
        this.iterationCount = props.getIntProperty(COMPONENT_COUNT_KEY);
        String componentName = props.getProperty(COMPONENT_KEY);
        this.componentGame = (Game)props.newObjectProperty(componentName);
        this.config = (GameConfiguration)props.singletonObjectProperty(GameConfiguration.class);
        this.name = props.getName();
    }
}

