/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Game;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.ScoringWeights;
import com.anji.tournament.SimpleTournament;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class KRandomOppsTournament
extends SimpleTournament
implements Configurable {
    private static final String K_KEY = "krandomopps.k";
    private static final int DEFAULT_K = 5;
    private int k = 5;
    private Set currentPlayerOpponents = new HashSet();
    private SimpleTournament.PlayerPair currentPlayerPair;
    private Iterator playerAndResultsIterator;
    private Random rand = new Random();

    public KRandomOppsTournament() {
    }

    public KRandomOppsTournament(Game aGame, int aK, ScoringWeights aWeights, Random aRand) {
        super(aGame, aWeights);
        this.k = aK;
        this.rand = aRand;
    }

    @Override
    public void init(Properties props) throws Exception {
        super.init(props);
        Randomizer randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        this.k = props.getIntProperty(K_KEY, 5);
        this.rand = randomizer.getRand();
    }

    @Override
    protected boolean hasNextPlayerPair() {
        return this.currentPlayerPair != null && (this.currentPlayerOpponents.size() < this.k || this.playerAndResultsIterator.hasNext());
    }

    @Override
    protected SimpleTournament.PlayerPair nextPlayerPair() {
        if (this.currentPlayerPair != null) {
            if (this.currentPlayerOpponents.size() >= this.k) {
                if (this.playerAndResultsIterator.hasNext()) {
                    this.currentPlayerPair.contestant = (PlayerResults)this.playerAndResultsIterator.next();
                    this.currentPlayerPair.opponent = null;
                    this.currentPlayerOpponents.clear();
                } else {
                    this.currentPlayerPair = null;
                }
            }
            if (this.currentPlayerPair != null) {
                do {
                    PlayerResults playerResults = (PlayerResults)this.getResults().get(this.rand.nextInt(this.getResults().size()));
                    this.currentPlayerPair.opponent = new PlayerResults(playerResults.getPlayer());
                } while (this.currentPlayerPair.opponent.equals(this.currentPlayerPair.contestant) || this.currentPlayerOpponents.contains(this.currentPlayerPair.opponent));
                this.currentPlayerOpponents.add(this.currentPlayerPair.opponent);
            }
        }
        return this.currentPlayerPair;
    }

    @Override
    protected void startTournament() {
        int numPlayers = this.getResults().size();
        if (this.k > numPlayers - 1) {
            throw new IllegalStateException("not enough players (" + numPlayers + ") for k opponents (" + this.k + ")");
        }
        this.currentPlayerOpponents.clear();
        this.playerAndResultsIterator = this.getResults().iterator();
        this.currentPlayerPair = new SimpleTournament.PlayerPair();
        if (this.playerAndResultsIterator.hasNext()) {
            this.currentPlayerPair.contestant = (PlayerResults)this.playerAndResultsIterator.next();
        }
    }

    @Override
    public int getMaxScore() {
        return this.k * this.getGame().getMaxScore(this.getScoringWeights());
    }

    @Override
    public int getMinScore() {
        return this.k * this.getGame().getMinScore(this.getScoringWeights());
    }

    @Override
    protected void endTournament() {
    }
}

