/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Player;
import com.anji.tournament.PlayerStats;
import com.anji.tournament.ScoringWeights;

public class PlayerResults {
    private Player player;
    private PlayerStats stats = new PlayerStats();
    private ScoringWeights weights = null;

    public PlayerResults(Player aPlayer, ScoringWeights aWeights) {
        this.player = aPlayer;
        this.weights = aWeights;
    }

    public PlayerResults(Player aPlayer) {
        this(aPlayer, null);
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerStats getResults() {
        return this.stats;
    }

    public float getScore() {
        return this.weights == null ? 0.0f : this.weights.calculateTotalScore(this.stats);
    }

    public String toString() {
        return new StringBuffer().append(this.player.getPlayerId()).append(": ").append(this.stats.toString()).append(": ").append(this.getScore()).toString();
    }

    public int hashCode() {
        return this.player.getPlayerId().hashCode();
    }

    public boolean equals(Object o) {
        PlayerResults other = (PlayerResults)o;
        return this.player.equals(other.getPlayer());
    }
}

