/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.util.XmlPersistable;
import java.util.Random;
import org.apache.log4j.Logger;

public class PlayerStats
implements XmlPersistable {
    private static final Logger logger = Logger.getLogger(PlayerStats.class);
    private static final String XML_TAG = "game-result";
    private int wins;
    private int losses;
    private int ties;
    private int rawScore = 0;

    public PlayerStats() {
        this(0, 0, 0);
    }

    public PlayerStats(int someWins, int someLosses, int someTies) {
        this.wins = someWins;
        this.losses = someLosses;
        this.ties = someTies;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getTies() {
        return this.ties;
    }

    public int getWins() {
        return this.wins;
    }

    public int getRawScore() {
        return this.rawScore;
    }

    public void incrementLosses(int newLosses) {
        this.losses += newLosses;
    }

    public void incrementTies(int newTies) {
        this.ties += newTies;
    }

    public void incrementWins(int newWins) {
        this.wins += newWins;
    }

    public void incrementRawScore(int newRawScore) {
        this.rawScore += newRawScore;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this.wins).append("-").append(this.losses).append("-").append(this.ties).append(": ").append(this.rawScore);
        return result2.toString();
    }

    @Override
    public String toXml() {
        StringBuffer result2 = new StringBuffer("<").append(XML_TAG);
        result2.append(" wins=\"").append(this.wins).append("\" losses=\"").append(this.losses);
        result2.append("\" ties=\"").append(this.ties).append("\" />");
        return result2.toString();
    }

    public void increment(PlayerStats newResults) {
        this.incrementWins(newResults.wins);
        this.incrementTies(newResults.ties);
        this.incrementLosses(newResults.losses);
        this.incrementRawScore(newResults.rawScore);
    }

    public boolean equals(Object o) {
        PlayerStats other = (PlayerStats)o;
        return this.wins == other.wins && this.losses == other.losses && this.ties == other.ties && this.rawScore == other.rawScore;
    }

    public void set(int aWins, int aLosses, int aTies, int aRawScore) {
        this.wins = aWins;
        this.losses = aLosses;
        this.ties = aTies;
        this.rawScore = aRawScore;
    }

    public boolean isWin(Random rand) {
        boolean result2 = false;
        if (this.wins > this.losses) {
            result2 = true;
        } else if (this.wins < this.losses) {
            result2 = false;
        } else if (this.rawScore > 0) {
            result2 = true;
        } else if (this.rawScore < 0) {
            result2 = false;
        } else {
            logger.info("breaking tie with coin flip");
            result2 = rand.nextBoolean();
        }
        return result2;
    }

    @Override
    public String getXmlRootTag() {
        return XML_TAG;
    }

    @Override
    public String getXmld() {
        return Integer.toString(this.hashCode());
    }
}

