/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.PlayerStats;
import com.anji.util.Configurable;
import com.anji.util.Properties;

public class ScoringWeights
implements Configurable {
    private static final String WIN_VALUE_KEY = "win.value";
    private static final String LOSS_VALUE_KEY = "loss.value";
    private static final String TIE_VALUE_KEY = "tie.value";
    private static final String RAWSCORE_VALUE_KEY = "rawscore.value";
    private static final int DEFAULT_WIN_VALUE = 5;
    private static final int DEFAULT_LOSS_VALUE = 0;
    private static final int DEFAULT_TIE_VALUE = 2;
    private static final int DEFAULT_RAWSCORE_VALUE = 0;
    private int winValue = 5;
    private int lossValue = 0;
    private int tieValue = 2;
    private float rawScoreValue = 0.0f;

    public ScoringWeights(int aWinValue, int aLossValue, int aTieValue, float aRawScoreValue) {
        if (aLossValue > aTieValue || aTieValue > aWinValue || aWinValue < 0) {
            throw new IllegalArgumentException("illegal W-L-T weights: " + aWinValue + "-" + aLossValue + "-" + aTieValue);
        }
        this.winValue = aWinValue;
        this.lossValue = aLossValue;
        this.tieValue = aTieValue;
        this.rawScoreValue = aRawScoreValue;
    }

    public ScoringWeights() {
        this(5, 0, 2, 0.0f);
    }

    @Override
    public void init(Properties props) {
        this.winValue = props.getIntProperty(WIN_VALUE_KEY, 5);
        this.lossValue = props.getIntProperty(LOSS_VALUE_KEY, 0);
        this.tieValue = props.getIntProperty(TIE_VALUE_KEY, 2);
        this.rawScoreValue = props.getFloatProperty(RAWSCORE_VALUE_KEY, 0.0f);
    }

    public int getLossValue() {
        return this.lossValue;
    }

    public int getTieValue() {
        return this.tieValue;
    }

    public int getWinValue() {
        return this.winValue;
    }

    public float calculateTotalScore(PlayerStats results) {
        return (float)(results.getWins() * this.winValue + results.getLosses() * this.lossValue + results.getTies() * this.tieValue) + (float)results.getRawScore() * this.rawScoreValue;
    }

    public float calculateAverageScore(PlayerStats results) {
        return this.calculateTotalScore(results) / (float)(results.getWins() + results.getLosses() + results.getTies());
    }

    public float getRawScoreValue() {
        return this.rawScoreValue;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append(this.winValue).append("/").append(this.lossValue).append("/").append(this.tieValue).append("/").append(this.rawScoreValue);
        return result2.toString();
    }
}

