/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Game;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.PlayerResultsScoreComparator;
import com.anji.tournament.ScoringWeights;
import com.anji.tournament.Tournament;
import com.anji.tournament.TournamentPlayerResults;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class SimpleTournament
implements Tournament,
Configurable {
    public static final String COMPONENT_GAME_KEY = "component";
    private Game game;
    private List contestantResults = new ArrayList();
    private ScoringWeights scoringWeights;

    protected SimpleTournament(Game aGame, ScoringWeights aWeights) {
        this.game = aGame;
        this.scoringWeights = aWeights;
    }

    public SimpleTournament() {
    }

    @Override
    public void init(Properties props) throws Exception {
        this.scoringWeights = (ScoringWeights)props.singletonObjectProperty(ScoringWeights.class);
        String componentName = props.getProperty(COMPONENT_GAME_KEY);
        this.game = (Game)props.newObjectProperty(componentName);
    }

    @Override
    public void clearContestants() {
        this.contestantResults.clear();
    }

    @Override
    public void addContestant(Player player) {
        this.contestantResults.add(new PlayerResults(player, this.scoringWeights));
    }

    protected List getResults() {
        return this.contestantResults;
    }

    @Override
    public List playTournament() {
        this.startTournament();
        while (this.hasNextPlayerPair()) {
            this.playMatch(this.nextPlayerPair());
        }
        this.endTournament();
        return this.newTournamentResults();
    }

    private List newTournamentResults() {
        ArrayList<TournamentPlayerResults> tournamentResults = new ArrayList<TournamentPlayerResults>();
        Collections.sort(this.contestantResults, PlayerResultsScoreComparator.getDescendingInstance());
        Iterator it = this.contestantResults.iterator();
        int rank = 1;
        while (it.hasNext()) {
            PlayerResults pr = (PlayerResults)it.next();
            tournamentResults.add(new TournamentPlayerResults(pr, rank++, Math.round(pr.getScore())));
        }
        return tournamentResults;
    }

    protected void playMatch(PlayerPair pair) {
        this.game.play(pair.contestant, pair.opponent);
    }

    protected abstract void startTournament();

    protected abstract void endTournament();

    protected abstract PlayerPair nextPlayerPair();

    protected abstract boolean hasNextPlayerPair();

    protected ScoringWeights getScoringWeights() {
        return this.scoringWeights;
    }

    protected Game getGame() {
        return this.game;
    }

    protected class PlayerPair {
        public PlayerResults contestant;
        public PlayerResults opponent;

        protected PlayerPair() {
        }

        public String toString() {
            return new StringBuffer().append(this.contestant.getPlayer().getPlayerId()).append(" vs ").append(this.opponent.getPlayer().getPlayerId()).toString();
        }
    }
}

