/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Bracket;
import com.anji.tournament.Game;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerResults;
import com.anji.tournament.PlayerResultsScoreComparator;
import com.anji.tournament.ScoringWeights;
import com.anji.tournament.Tournament;
import com.anji.tournament.TournamentPlayerResults;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import com.anji.util.Randomizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SingleEliminationTournament
implements Tournament,
Configurable {
    private List contestants = new ArrayList();
    private ScoringWeights scoringWeights;
    private Random rand;
    private Game game;

    public SingleEliminationTournament() {
    }

    public SingleEliminationTournament(Game aGame, ScoringWeights aWeights, Random aRand) {
        this.init(aGame, aWeights, aRand);
    }

    private void init(Game aGame, ScoringWeights aWeights, Random aRand) {
        if (aWeights.getLossValue() > 0) {
            throw new IllegalArgumentException("can not have positive loss value for tournaments with variable numbers of games");
        }
        this.game = aGame;
        this.scoringWeights = aWeights;
        this.rand = aRand;
    }

    @Override
    public void clearContestants() {
        this.contestants.clear();
    }

    @Override
    public void addContestant(Player aContestant) {
        this.contestants.add(new PlayerResults(aContestant, this.scoringWeights));
    }

    @Override
    public List playTournament() {
        Bracket bracket = new Bracket("single", this.rand, this.contestants, this.game);
        ArrayList<TournamentPlayerResults> tourneyResults = new ArrayList<TournamentPlayerResults>();
        int rank = this.contestants.size();
        int roundScore = 0;
        while (bracket.size() > 1) {
            List losers = bracket.playBracket();
            Collections.sort(losers, PlayerResultsScoreComparator.getAscendingInstance());
            int tieBreakerBonus = 0;
            for (PlayerResults pr : losers) {
                tourneyResults.add(0, new TournamentPlayerResults(pr, rank--, roundScore + tieBreakerBonus++));
            }
            int n = roundScore = roundScore == 0 ? this.contestants.size() : roundScore * 2;
        }
        PlayerResults pr = (PlayerResults)bracket.getContestants().get(0);
        tourneyResults.add(0, new TournamentPlayerResults(pr, rank--, roundScore));
        return tourneyResults;
    }

    public int getMaxRounds() {
        int size = this.contestants.size();
        if (size < 2) {
            return 0;
        }
        double d = Math.log(size) / Math.log(2.0);
        return (int)Math.ceil(d);
    }

    @Override
    public int getMaxScore() {
        int size = this.contestants.size();
        if (size < 2) {
            return 0;
        }
        return (int)Math.pow(2.0, this.getMaxRounds() - 1) * size;
    }

    @Override
    public int getMinScore() {
        return 0;
    }

    @Override
    public void init(Properties props) throws Exception {
        Randomizer randomizer = (Randomizer)props.singletonObjectProperty(Randomizer.class);
        String componentName = props.getProperty("component");
        Game aGame = (Game)props.newObjectProperty(componentName);
        this.init(aGame, (ScoringWeights)props.singletonObjectProperty(ScoringWeights.class), randomizer.getRand());
    }
}

