/*
 * Decompiled with CFR 0.152.
 */
package com.anji.tournament;

import com.anji.tournament.Player;
import com.anji.tournament.PlayerTranscriber;
import com.anji.tournament.Tournament;
import com.anji.tournament.TournamentPlayerResults;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;

public class TournamentFitnessFunction
implements BulkFitnessFunction,
Configurable {
    private Logger logger = Logger.getLogger(TournamentFitnessFunction.class);
    private static final String TOURNAMENT_CLASS_KEY = "tournament";
    private static final String TRANSCRIBER_CLASS_KEY = "tournament.transcriber";
    private static final String MAX_FITNESS_KEY = "tournament.fitness.max";
    private static final String NONCHROMOSOME_CONTESTANTS_KEY = "tournament.nonchromosome.contestants";
    private Map playerToChromosomeMap = new HashMap();
    private Tournament tournament;
    private PlayerTranscriber transcriber;
    private int maxFitness = Integer.MAX_VALUE;
    private List nonChromosomeContestants = new ArrayList();

    public TournamentFitnessFunction() {
    }

    public TournamentFitnessFunction(Tournament aTournament, PlayerTranscriber aTranscriber) {
        this.tournament = aTournament;
        this.transcriber = aTranscriber;
    }

    @Override
    public void init(Properties props) {
        this.tournament = (Tournament)props.newObjectProperty(TOURNAMENT_CLASS_KEY);
        this.transcriber = (PlayerTranscriber)props.newObjectProperty(TRANSCRIBER_CLASS_KEY);
        this.maxFitness = props.getIntProperty(MAX_FITNESS_KEY, Integer.MAX_VALUE);
        this.nonChromosomeContestants = props.newObjectListProperty(NONCHROMOSOME_CONTESTANTS_KEY, new ArrayList());
    }

    @Override
    public void evaluate(List chroms) {
        this.playerToChromosomeMap.clear();
        this.tournament.clearContestants();
        for (Player contestant : this.nonChromosomeContestants) {
            this.tournament.addContestant(contestant);
        }
        for (Chromosome chrom : chroms) {
            try {
                Player contestant = this.transcriber.newPlayer(chrom);
                this.playerToChromosomeMap.put(contestant, chrom);
                this.tournament.addContestant(contestant);
            }
            catch (Throwable th) {
                this.logger.warn("error with chromosome " + chrom, th);
            }
        }
        List tourneyResults = this.tournament.playTournament();
        for (TournamentPlayerResults tourneyPlayerResults : tourneyResults) {
            float adjustedScore = tourneyPlayerResults.getTournamentScore() - this.tournament.getMinScore();
            float adjustedMaxScore = this.tournament.getMaxScore() - this.tournament.getMinScore();
            int normalizedScore = (int)(adjustedScore / adjustedMaxScore * (float)this.maxFitness);
            Chromosome c2 = (Chromosome)this.playerToChromosomeMap.get(tourneyPlayerResults.getPlayer());
            if (c2 == null) {
                this.logger.info(tourneyPlayerResults);
                continue;
            }
            c2.setFitnessValue(normalizedScore);
        }
    }

    @Override
    public int getMaxFitnessValue() {
        return this.maxFitness;
    }
}

