/*
 * Decompiled with CFR 0.152.
 */
package com.anji.ttt;

import com.anji.ttt.Board;
import java.util.Arrays;

public class TttBoard
implements Board {
    private static final int BOARD_SIZE = 3;
    private int[] boardState;

    @Override
    public void initializeBoard() {
        this.boardState = new int[9];
        Arrays.fill(this.boardState, 0);
    }

    @Override
    public boolean checkLegalMove(int newMove) {
        boolean legalMove = this.boardState[newMove] == 0;
        return legalMove;
    }

    @Override
    public void updateBoard(int newMove) {
        this.boardState[newMove] = 1;
    }

    @Override
    public boolean checkForWin() {
        int j;
        boolean wonGame = false;
        int[][] matrixBoardState = new int[3][3];
        int boardIdx = 0;
        int i = 0;
        while (i < 3) {
            int j2 = 0;
            while (j2 < 3) {
                matrixBoardState[i][j2] = this.boardState[boardIdx];
                ++boardIdx;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            int rowTotal = 0;
            j = 0;
            while (j < 3) {
                rowTotal += matrixBoardState[i][j];
                ++j;
            }
            if (rowTotal == 3) {
                wonGame = true;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            int columnTotal = 0;
            j = 0;
            while (j < 3) {
                columnTotal += matrixBoardState[j][i];
                ++j;
            }
            if (columnTotal == 3) {
                wonGame = true;
            }
            ++i;
        }
        int diagTotal = 0;
        int i2 = 0;
        while (i2 < 3) {
            j = 0;
            while (j < 3) {
                if (i2 == j) {
                    diagTotal += matrixBoardState[i2][j];
                }
                ++j;
            }
            if (diagTotal == 3) {
                wonGame = true;
            }
            ++i2;
        }
        diagTotal = 0;
        i2 = 0;
        while (i2 < 3) {
            j = 0;
            while (j < 3) {
                if (i2 + j == 2) {
                    diagTotal += matrixBoardState[i2][j];
                }
                ++j;
            }
            if (diagTotal == 3) {
                wonGame = true;
            }
            ++i2;
        }
        return wonGame;
    }

    @Override
    public boolean checkForTie() {
        boolean tieGame = false;
        boolean boardFull = true;
        int i = 0;
        while (i < this.boardState.length) {
            if (this.boardState[i] == 0) {
                boardFull = false;
            }
            ++i;
        }
        boolean wonGame = this.checkForWin();
        if (!wonGame && boardFull) {
            tieGame = true;
        }
        return tieGame;
    }

    @Override
    public String displayBoard() {
        StringBuffer result2 = new StringBuffer();
        int i = 0;
        while (i < this.boardState.length) {
            if (this.boardState[i] == -1) {
                result2.append(" ");
            } else {
                result2.append("  ");
            }
            result2.append(this.boardState[i]);
            if ((i + 1) % 3 == 0) {
                result2.append("\n");
            }
            ++i;
        }
        result2.append("\n\n");
        return result2.toString();
    }

    @Override
    public int[] getBoardState() {
        return this.boardState;
    }

    @Override
    public void swap() {
        int i = 0;
        while (i < this.boardState.length) {
            int n = i++;
            this.boardState[n] = this.boardState[n] * -1;
        }
    }

    @Override
    public int getBoardSize() {
        return 3;
    }
}

