/*
 * Decompiled with CFR 0.152.
 */
package com.anji.ttt;

import com.anji.integration.Activator;
import com.anji.integration.ActivatorTranscriber;
import com.anji.integration.TranscriberException;
import com.anji.tournament.Player;
import com.anji.tournament.PlayerTranscriber;
import com.anji.ttt.BoardPlayer;
import com.anji.ttt.TttNeuralNetPlayer;
import com.anji.ttt.TttNineByOneNeuralNetPlayer;
import com.anji.ttt.TttRotatingNeuralNetPlayer;
import com.anji.util.Configurable;
import com.anji.util.Properties;
import org.jgap.Chromosome;

public class TttPlayerTranscriber
implements PlayerTranscriber,
Configurable {
    private static final String TYPE_KEY = "ttt.player.type";
    private static final String TYPE_DEFAULT = "default";
    private static final String TYPE_9x1 = "9x1";
    private static final String TYPE_ROTATING = "rotating";
    private ActivatorTranscriber activatorTranscriber;
    private String type = "default";

    @Override
    public Object transcribe(Chromosome c2) throws TranscriberException {
        return this.newPlayer(c2);
    }

    @Override
    public Player newPlayer(Chromosome c2) throws TranscriberException {
        return this.newBoardPlayer(c2);
    }

    public BoardPlayer newBoardPlayer(Chromosome c2) throws TranscriberException {
        Activator activator = this.activatorTranscriber.newActivator(c2);
        if (TYPE_9x1.equals(this.type)) {
            return new TttNineByOneNeuralNetPlayer(activator);
        }
        if (TYPE_ROTATING.equals(this.type)) {
            return new TttRotatingNeuralNetPlayer(activator);
        }
        return new TttNeuralNetPlayer(activator);
    }

    @Override
    public Class getPhenotypeClass() {
        return BoardPlayer.class;
    }

    @Override
    public void init(Properties props) throws Exception {
        this.activatorTranscriber = (ActivatorTranscriber)props.singletonObjectProperty(ActivatorTranscriber.class);
        this.type = props.getProperty(TYPE_KEY, TYPE_DEFAULT);
    }
}

