/*
 * Decompiled with CFR 0.152.
 */
package com.anji.util;

import com.anji.util.Configurable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.regexp.RE;

public class Properties
extends java.util.Properties {
    public static final String CLASS_SUFFIX = ".class";
    private static Logger logger = Logger.getLogger(Properties.class);
    private HashSet loggedProps = new HashSet();
    private HashMap keyToSingletonsMap = new HashMap();
    private HashMap classToSingletonsMap = new HashMap();
    private String name = "default";

    public Properties() {
    }

    public Properties(java.util.Properties values) {
        this.putAll((Map<?, ?>)values);
    }

    public Properties(String resource) throws IOException {
        this.loadFromResource(resource);
        logger.info("loaded properties from " + resource);
    }

    public void loadFromResource(String resource) throws IOException {
        this.loadFromResourceWithoutLogging(resource);
        java.util.Properties log4jProps = new java.util.Properties();
        log4jProps.putAll((Map<?, ?>)this);
        PropertyConfigurator.configure(log4jProps);
    }

    public void loadFromResourceWithoutLogging(String resource) throws IOException {
        InputStream in = ClassLoader.getSystemResourceAsStream(resource);
        this.load(in);
        this.setName(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String key, String value, String defaultValue) {
        HashSet hashSet = this.loggedProps;
        synchronized (hashSet) {
            if (!this.loggedProps.contains(key)) {
                StringBuffer log = new StringBuffer("Properties: ");
                log.append(key).append(" == ").append(value);
                if (value == null) {
                    log.append(" [").append(defaultValue).append("]");
                }
                logger.info(log);
                this.loggedProps.add(key);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        return value;
    }

    public boolean getBooleanProperty(String key) {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        return Boolean.valueOf(value);
    }

    public long getLongProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad value for property " + key + ": " + e);
        }
    }

    public int getIntProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad value for property " + key + ": " + e);
        }
    }

    public short getShortProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad value for property " + key + ": " + e);
        }
    }

    public float getFloatProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad value for property " + key + ": " + e);
        }
    }

    public double getDoubleProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("bad value for property " + key + ": " + e);
        }
    }

    @Override
    public String getProperty(String key, String defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, defaultVal);
        return value == null ? defaultVal : value;
    }

    public boolean getBooleanProperty(String key, boolean defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Boolean.toString(defaultVal));
        return value == null ? defaultVal : Boolean.valueOf(value);
    }

    public long getLongProperty(String key, long defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Long.toString(defaultVal));
        return value == null ? defaultVal : Long.parseLong(value);
    }

    public int getIntProperty(String key, int defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Integer.toString(defaultVal));
        return value == null ? defaultVal : Integer.parseInt(value);
    }

    public short getShortProperty(String key, short defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Short.toString(defaultVal));
        return value == null ? defaultVal : Short.parseShort(value);
    }

    public float getFloatProperty(String key, float defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Float.toString(defaultVal));
        return value == null ? defaultVal : Float.parseFloat(value);
    }

    public double getDoubleProperty(String key, double defaultVal) {
        String value = super.getProperty(key);
        this.log(key, value, Double.toString(defaultVal));
        return value == null ? defaultVal : Double.parseDouble(value);
    }

    public Set getKeysForPattern(String pattern) {
        RE regex = new RE(pattern);
        HashSet<String> result2 = new HashSet<String>();
        for (String string : super.keySet()) {
            if (!regex.match(string)) continue;
            result2.add(string);
        }
        return result2;
    }

    public Set getPropertiesForPattern(String pattern) {
        RE regex = new RE(pattern);
        HashSet<String> result2 = new HashSet<String>();
        for (String string : super.keySet()) {
            if (!regex.match(string)) continue;
            result2.add(this.getProperty(string));
        }
        return result2;
    }

    public Properties getSubProperties(String prefix) {
        Properties result2 = new Properties(this);
        Properties newProps = new Properties();
        for (String string : this.keySet()) {
            if (!string.startsWith(prefix)) continue;
            result2.remove(string);
            newProps.put(string.substring(prefix.length()), super.getProperty(string));
        }
        result2.putAll((Map<?, ?>)newProps);
        result2.setName(prefix);
        return result2;
    }

    public File getDirProperty(String key) {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        File result2 = new File(value);
        if (result2.exists()) {
            if (!result2.isDirectory()) {
                throw new IllegalArgumentException("property " + key + "=" + value + " is not a directory");
            }
        } else if (!result2.mkdir()) {
            throw new IllegalStateException("failed creating directory " + key + "=" + value);
        }
        return result2;
    }

    public FileInputStream getFileInputProperty(String key) throws FileNotFoundException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        return new FileInputStream(value);
    }

    public FileOutputStream getFileOutputProperty(String key) throws FileNotFoundException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        return new FileOutputStream(value);
    }

    public InputStream getResourceProperty(String key) {
        String value = super.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        this.log(key, value, null);
        return ClassLoader.getSystemResourceAsStream(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object singletonObjectProperty(String key) {
        HashMap hashMap = this.keyToSingletonsMap;
        synchronized (hashMap) {
            Object result2 = this.keyToSingletonsMap.get(key);
            if (result2 == null) {
                result2 = this.newObjectProperty(key);
                this.keyToSingletonsMap.put(key, result2);
            }
            return result2;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + ": " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object singletonObjectProperty(Class aClass) {
        HashMap hashMap = this.classToSingletonsMap;
        synchronized (hashMap) {
            Object result2 = this.classToSingletonsMap.get(aClass);
            if (result2 == null) {
                result2 = this.newObjectProperty(aClass);
                this.classToSingletonsMap.put(aClass, result2);
            }
            return result2;
        }
    }

    public Object newObjectProperty(String key) {
        try {
            Class cl = this.getClassProperty(String.valueOf(key) + CLASS_SUFFIX);
            Object result2 = cl.newInstance();
            if (result2 instanceof Configurable) {
                Configurable conf = (Configurable)result2;
                conf.init(this.getSubProperties(String.valueOf(key) + "."));
            }
            return result2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create object for key " + key + ": " + e);
        }
    }

    public Object newObjectProperty(Class aClass) {
        try {
            Object result2 = aClass.newInstance();
            if (result2 instanceof Configurable) {
                Configurable c2 = (Configurable)result2;
                c2.init(this);
            }
            return result2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't create object for class " + aClass + ": " + e);
        }
    }

    public Class getClassProperty(String key) {
        try {
            String value = super.getProperty(key);
            if (value == null) {
                throw new IllegalArgumentException("no value for " + key);
            }
            this.log(key, value, null);
            Class<?> myClass = Class.forName(value);
            return myClass;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get class for key " + key + ": " + e);
        }
    }

    public Class getClassProperty(String key, Class defaultVal) {
        String val = super.getProperty(key);
        this.log(key, val, defaultVal.toString());
        if (val == null) {
            return defaultVal;
        }
        try {
            Class<?> myClass = Class.forName(val);
            return myClass;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get class for key " + key + ": " + e);
        }
    }

    public static double[][] loadArrayFromFile(InputStream in) throws FileNotFoundException, IOException {
        ArrayList<double[]> rows = new ArrayList<double[]>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            double[] row = Properties.loadRowFromString(line);
            rows.add(row);
            line = reader.readLine();
        }
        double[][] result2 = new double[rows.size()][];
        Iterator it = rows.iterator();
        int i = 0;
        while (it.hasNext()) {
            result2[i++] = (double[])it.next();
        }
        return result2;
    }

    public static boolean[][] loadBooleanArrayFromFile(InputStream in) throws FileNotFoundException, IOException {
        ArrayList<boolean[]> rows = new ArrayList<boolean[]>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            boolean[] row = Properties.loadBooleanRowFromString(line);
            rows.add(row);
            line = reader.readLine();
        }
        boolean[][] result2 = new boolean[rows.size()][];
        Iterator it = rows.iterator();
        int i = 0;
        while (it.hasNext()) {
            result2[i++] = (boolean[])it.next();
        }
        return result2;
    }

    protected static double[] loadRowFromString(String line) {
        ArrayList<Double> row = new ArrayList<Double>();
        StringTokenizer tok = new StringTokenizer(line, "; ");
        while (tok.hasMoreTokens()) {
            String element = tok.nextToken();
            Double value = Double.valueOf(element);
            row.add(value);
        }
        double[] result2 = new double[row.size()];
        Iterator it = row.iterator();
        int i = 0;
        while (it.hasNext()) {
            result2[i++] = (Double)it.next();
        }
        return result2;
    }

    public static boolean[] loadBooleanRowFromString(String line) {
        ArrayList<Boolean> row = new ArrayList<Boolean>();
        StringTokenizer tok = new StringTokenizer(line, "; ");
        while (tok.hasMoreTokens()) {
            String element = tok.nextToken();
            Boolean value = Boolean.valueOf(element);
            row.add(value);
        }
        boolean[] result2 = new boolean[row.size()];
        Iterator it = row.iterator();
        int i = 0;
        while (it.hasNext()) {
            result2[i++] = (Boolean)it.next();
        }
        return result2;
    }

    public List newObjectListProperty(String key, List defaultList) {
        String val = super.getProperty(key);
        if (val == null) {
            this.log(key, val, defaultList == null ? "null" : defaultList.toString());
            return defaultList;
        }
        StringTokenizer tok = new StringTokenizer(val, ",");
        ArrayList<Object> results = new ArrayList<Object>();
        while (tok.hasMoreTokens()) {
            String objectName = tok.nextToken().trim();
            Object o = this.newObjectProperty(objectName);
            results.add(o);
        }
        this.log(key, val, null);
        return results;
    }

    public List newObjectListProperty(String key) {
        List result2 = this.newObjectListProperty(key, null);
        if (result2 == null) {
            throw new IllegalArgumentException("no value for " + key);
        }
        return result2;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String aName) {
        this.name = aName;
    }
}

