/*
 * Decompiled with CFR 0.152.
 */
package com.anji.util;

import com.anji.imaging.ImageFileFilter;
import com.anji.persistence.Persistence;
import com.anji.util.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class Reset {
    private Properties props;
    private boolean userInteraction = true;

    public Reset(String propFilePath) throws IOException {
        this.props = new Properties();
        this.props.loadFromResourceWithoutLogging(propFilePath);
    }

    public Reset(Properties someProps) {
        this.props = someProps;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("ANJI v2.0, Copyright (C) 2004 Derek James and Philip Tucker\nANJI comes with ABSOLUTELY NO WARRANTY\nThis is free software, and you are welcome to redistribute it\nunder the conditions of the GNU General Public License.");
        if (args.length < 1) {
            System.err.println("usage: <cmd> <properties-file>");
            System.exit(-1);
        }
        Reset reset = new Reset(args[0]);
        reset.reset();
    }

    private boolean userResponse(String question) throws IOException {
        if (!this.userInteraction) {
            return true;
        }
        System.out.print(String.valueOf(question) + " ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String response = reader.readLine();
        return response.toLowerCase().startsWith("y");
    }

    public void reset() throws IOException {
        String fileName;
        boolean deleteAll = this.userResponse("Delete all?");
        if (deleteAll || this.userResponse("Delete database (including runs and chromosomes)?")) {
            Persistence db = (Persistence)this.props.singletonObjectProperty("persistence");
            db.reset();
        }
        ArrayList<String> fileNamesToDelete = new ArrayList<String>();
        if ((deleteAll || this.userResponse("Delete ID Factory?")) && (fileName = this.props.getProperty("id.file", null)) != null && fileName.length() > 0) {
            fileNamesToDelete.add(fileName);
        }
        if ((deleteAll || this.userResponse("Delete ID map?")) && (fileName = this.props.getProperty("neat.id.file", null)) != null && fileName.length() > 0) {
            fileNamesToDelete.add(fileName);
        }
        if (deleteAll || this.userResponse("Delete log files?")) {
            Set keys = this.props.getKeysForPattern("log4j\\.appender\\.*");
            for (String key : keys) {
                String suffix = key.substring("log4j.appender.".length());
                if (suffix.indexOf(46) != -1) continue;
                String val = this.props.getProperty(key);
                if ("org.apache.log4j.FileAppender".equals(val)) {
                    String fileName2 = this.props.getProperty(String.valueOf(key) + ".File");
                    fileNamesToDelete.add(fileName2);
                    continue;
                }
                if (!"org.apache.log4j.RollingFileAppender".equals(val)) continue;
                String fullFileName = this.props.getProperty(String.valueOf(key) + ".File");
                File base = new File(fullFileName);
                File parent = base.getParentFile();
                final String fileName3 = base.getName();
                String[] fileNames = parent.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File aDir, String aName) {
                        return aName.startsWith(fileName3);
                    }
                });
                int i = 0;
                while (i < fileNames.length) {
                    fileNamesToDelete.add(String.valueOf(parent.getAbsolutePath()) + File.separator + fileNames[i]);
                    ++i;
                }
            }
        }
        for (String fileName4 : fileNamesToDelete) {
            if (fileName4 == null || fileName4.length() <= 0) continue;
            File f = new File(fileName4);
            if (f.delete()) {
                System.out.println("deleted " + f.getAbsolutePath());
                continue;
            }
            System.err.println("error deleting " + f.getAbsolutePath());
        }
        if (deleteAll || this.userResponse("Delete images?")) {
            ArrayList<File> filesToDelete = new ArrayList<File>();
            try {
                File matchDir = this.props.getDirProperty("image.matches");
                filesToDelete.addAll(Arrays.asList(matchDir.listFiles(ImageFileFilter.getInstance())));
            }
            catch (Exception e) {
                System.err.println("could not get files for property image.matches");
            }
            try {
                File mismatchDir = this.props.getDirProperty("image.mismatches");
                filesToDelete.addAll(Arrays.asList(mismatchDir.listFiles(ImageFileFilter.getInstance())));
            }
            catch (Exception e) {
                System.err.println("could not get files for property image.mismatches");
            }
            for (File f : filesToDelete) {
                if (f.delete()) {
                    System.out.println("deleted " + f.getAbsolutePath());
                    continue;
                }
                System.err.println("error deleting " + f.getAbsolutePath());
            }
        }
    }

    public void setUserInteraction(boolean aUserInteraction) {
        this.userInteraction = aUserInteraction;
    }
}

